/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolver;
import cn.boboweike.carrot.server.concurrent.UnresolvableConcurrentTaskModificationException;
import cn.boboweike.carrot.server.concurrent.statechanges.AllowedConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileEnqueuedConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileFailedConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileProcessingConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileScheduledConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.DeletedWhileSucceededConcurrentStateChange;
import cn.boboweike.carrot.server.concurrent.statechanges.PermanentlyDeletedWhileProcessingConcurrentStateChange;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.tasks.Task;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultConcurrentTaskModificationResolver
implements ConcurrentTaskModificationResolver {
    private final PartitionedStorageProvider storageProvider;
    private final List<AllowedConcurrentStateChange> allowedConcurrentStateChanges;

    public DefaultConcurrentTaskModificationResolver(PartitionedStorageProvider storageProvider, TaskZooKeeper taskZooKeeper) {
        this.storageProvider = storageProvider;
        this.allowedConcurrentStateChanges = Arrays.asList(new PermanentlyDeletedWhileProcessingConcurrentStateChange(taskZooKeeper), new DeletedWhileProcessingConcurrentStateChange(taskZooKeeper), new DeletedWhileSucceededConcurrentStateChange(), new DeletedWhileFailedConcurrentStateChange(), new DeletedWhileEnqueuedConcurrentStateChange(), new DeletedWhileScheduledConcurrentStateChange());
    }

    @Override
    public void resolve(ConcurrentTaskModificationException e) {
        List<Task> concurrentUpdatedTasks = e.getConcurrentUpdatedTasks();
        List<ConcurrentTaskModificationResolveResult> failedToResolve = concurrentUpdatedTasks.stream().map(this::resolve).filter(ConcurrentTaskModificationResolveResult::failed).collect(Collectors.toList());
        if (!failedToResolve.isEmpty()) {
            throw new UnresolvableConcurrentTaskModificationException(failedToResolve);
        }
    }

    public ConcurrentTaskModificationResolveResult resolve(Task localTask) {
        Task taskFromStorage = this.getTaskFromStorageProvider(localTask);
        return this.allowedConcurrentStateChanges.stream().filter(allowedConcurrentStateChange -> allowedConcurrentStateChange.matches(localTask, taskFromStorage)).findFirst().map(allowedConcurrentStateChange -> allowedConcurrentStateChange.resolve(localTask, taskFromStorage)).orElse(ConcurrentTaskModificationResolveResult.failed(localTask, taskFromStorage));
    }

    private Task getTaskFromStorageProvider(Task localTask) {
        try {
            return this.storageProvider.getTaskById(localTask.getId());
        }
        catch (TaskNotFoundException e) {
            return null;
        }
    }
}

