/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.SevereCarrotException;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.diagnostics.DiagnosticsBuilder;
import java.util.List;
import java.util.stream.Collectors;

public class UnresolvableConcurrentTaskModificationException
extends ConcurrentTaskModificationException
implements SevereCarrotException.DiagnosticsAware {
    private final List<ConcurrentTaskModificationResolveResult> concurrentTaskModificationResolveResults;

    public UnresolvableConcurrentTaskModificationException(List<ConcurrentTaskModificationResolveResult> concurrentTaskModificationResolveResults) {
        super(concurrentTaskModificationResolveResults.stream().map(ConcurrentTaskModificationResolveResult::getLocalTask).collect(Collectors.toList()));
        this.concurrentTaskModificationResolveResults = concurrentTaskModificationResolveResults;
    }

    @Override
    public DiagnosticsBuilder getDiagnosticsInfo() {
        return DiagnosticsBuilder.diagnostics().withTitle("Concurrent modified tasks:").with(this.concurrentTaskModificationResolveResults, (resolveResult, diagnosticsBuilder) -> this.appendDiagnosticsInfo((DiagnosticsBuilder)diagnosticsBuilder, (ConcurrentTaskModificationResolveResult)resolveResult));
    }

    private void appendDiagnosticsInfo(DiagnosticsBuilder diagnostics, ConcurrentTaskModificationResolveResult resolveResult) {
        Task localTask = resolveResult.getLocalTask();
        Task taskFromStorage = resolveResult.getTaskFromStorage();
        diagnostics.withLine("Task id: " + localTask.getId()).withIndentedLine("Local version: " + localTask.getVersion() + "; Storage version: " + taskFromStorage.getVersion()).withIndentedLine("Local state: " + this.getTaskStates(localTask)).withIndentedLine("Storage state: " + this.getTaskStates(taskFromStorage));
    }

    private String getTaskStates(Task task) {
        StringBuilder result = new StringBuilder();
        int taskStatesToShow = Math.min(3, task.getTaskStates().size());
        for (int i = 1; i <= taskStatesToShow; ++i) {
            TaskState taskState = task.getTaskState(-i);
            result.append((Object)taskState.getName());
            result.append(" (at " + taskState.getUpdatedAt());
            if (taskState instanceof ProcessingState) {
                result.append(" on BackgroundTaskServer " + ((ProcessingState)taskState).getServerId());
            }
            result.append(")");
            if (i >= taskStatesToShow) continue;
            result.append(" \u2190 ");
        }
        return result.toString();
    }
}

