/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.concurrent;

import cn.boboweike.carrot.server.TaskZooKeeper;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolveResult;
import cn.boboweike.carrot.server.concurrent.ConcurrentTaskModificationResolver;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.states.IllegalTaskStateChangeException;
import cn.boboweike.carrot.utils.annotations.Beta;
import java.util.List;

@Beta
public class UseStorageProviderTaskConcurrentTaskModificationResolver
implements ConcurrentTaskModificationResolver {
    private final TaskZooKeeper taskZooKeeper;

    public UseStorageProviderTaskConcurrentTaskModificationResolver(TaskZooKeeper taskZooKeeper) {
        this.taskZooKeeper = taskZooKeeper;
    }

    @Override
    public void resolve(ConcurrentTaskModificationException e) {
        List<Task> concurrentUpdatedTasks = e.getConcurrentUpdatedTasks();
        concurrentUpdatedTasks.forEach(task -> this.resolve((Task)task, e));
    }

    public ConcurrentTaskModificationResolveResult resolve(Task localTask, ConcurrentTaskModificationException e) {
        this.failLocalIfPossible(localTask, e);
        Thread threadProcessingTask = this.taskZooKeeper.getThreadProcessingTask(localTask);
        if (threadProcessingTask != null) {
            threadProcessingTask.interrupt();
        }
        return ConcurrentTaskModificationResolveResult.succeeded(localTask);
    }

    private void failLocalIfPossible(Task localTask, ConcurrentTaskModificationException e) {
        try {
            localTask.failed("Task is already updated in StorageProvider, discarding local task.", e);
        }
        catch (IllegalTaskStateChangeException illegalTaskStateChangeException) {
            // empty catch block
        }
    }
}

