/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.dashboard;

import cn.boboweike.carrot.server.dashboard.DashboardNotification;
import cn.boboweike.carrot.server.dashboard.mappers.CpuAllocationIrregularityNotificationMapper;
import cn.boboweike.carrot.server.dashboard.mappers.DashboardNotificationMapper;
import cn.boboweike.carrot.server.dashboard.mappers.NewCarrotVersionNotificationMapper;
import cn.boboweike.carrot.server.dashboard.mappers.SevereCarrotExceptionNotificationMapper;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;

public class DashboardNotificationManager {
    private final PartitionedStorageProvider storageProvider;
    private final Set<DashboardNotificationMapper<?>> notificationMappers;

    public DashboardNotificationManager(UUID backgroundTaskServerId, PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
        this.notificationMappers = new HashSet<DashboardNotificationMapper>(Arrays.asList(new SevereCarrotExceptionNotificationMapper(backgroundTaskServerId, storageProvider), new CpuAllocationIrregularityNotificationMapper(backgroundTaskServerId), new NewCarrotVersionNotificationMapper()));
    }

    public void handle(Exception e) {
        if (e instanceof DashboardNotification) {
            this.notify((DashboardNotification)((Object)e));
        }
    }

    public void notify(DashboardNotification e) {
        this.notificationMappers.stream().filter(notificationMapper -> notificationMapper.supports(e)).map(notificationMapper -> notificationMapper.map(e)).forEach(this.storageProvider::saveMetadata);
    }

    public void deleteNotification(Class<? extends DashboardNotification> notificationToDelete) {
        this.storageProvider.deleteMetadata(notificationToDelete.getSimpleName());
    }

    public <T extends DashboardNotification> T getDashboardNotification(Class<T> notificationClass) {
        return (T)((DashboardNotification)this.storageProvider.getMetadata(notificationClass.getSimpleName()).stream().map(metadata -> (DashboardNotification)ReflectionUtils.newInstance(notificationClass, metadata)).findFirst().orElse(null));
    }
}

