/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.metrics;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToDoubleFunction;

public class BackgroundTaskServerMetricsBinder
implements AutoCloseable {
    private final BackgroundTaskServer backgroundTaskServer;
    private final MeterRegistry meterRegistry;
    private final List<Meter> meters;

    public BackgroundTaskServerMetricsBinder(BackgroundTaskServer backgroundTaskServer, MeterRegistry meterRegistry) {
        this.backgroundTaskServer = backgroundTaskServer;
        this.meterRegistry = meterRegistry;
        this.meters = new ArrayList<Meter>();
        this.registerBackgroundTaskServerMetrics();
    }

    public void registerBackgroundTaskServerMetrics() {
        this.meters.add((Meter)this.registerFunction("poll-interval-in-seconds", bgTaskServer -> bgTaskServer.getServerStatus().getPollIntervalInSeconds()));
        this.meters.add((Meter)this.registerFunction("worker-pool-size", bgTaskServer -> bgTaskServer.getServerStatus().getWorkerPoolSize()));
        this.meters.add((Meter)this.registerGauge("process-all-located-memory", bgTaskServer -> bgTaskServer.getServerStatus().getProcessAllocatedMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("process-free-memory", bgTaskServer -> bgTaskServer.getServerStatus().getProcessFreeMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("system-free-memory", bgTaskServer -> bgTaskServer.getServerStatus().getSystemFreeMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("system-total-memory", bgTaskServer -> bgTaskServer.getServerStatus().getSystemTotalMemory().longValue()));
        this.meters.add((Meter)this.registerGauge("first-heartbeat", bgTaskServer -> bgTaskServer.getServerStatus().getFirstHeartbeat().getEpochSecond()));
        this.meters.add((Meter)this.registerGauge("last-heartbeat", bgTaskServer -> bgTaskServer.getServerStatus().getLastHeartbeat().getNano()));
    }

    private FunctionCounter registerFunction(String name, ToDoubleFunction<BackgroundTaskServer> func) {
        return FunctionCounter.builder((String)this.toMicroMeterName(name), (Object)this.backgroundTaskServer, func).tag("id", this.backgroundTaskServer.getId().toString()).register(this.meterRegistry);
    }

    private Gauge registerGauge(String name, ToDoubleFunction<BackgroundTaskServer> func) {
        return Gauge.builder((String)this.toMicroMeterName(name), (Object)this.backgroundTaskServer, func).tag("id", this.backgroundTaskServer.getId().toString()).register(this.meterRegistry);
    }

    private String toMicroMeterName(String name) {
        return "carrot.background-task-server." + name;
    }

    @Override
    public void close() {
        this.meters.forEach(meter -> {
            try {
                meter.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }
}

