/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.server.runner.BackgroundTaskRunner;
import cn.boboweike.carrot.server.runner.RunnerTaskContext;
import cn.boboweike.carrot.server.runner.ThreadLocalTaskContext;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.IntStream;

public abstract class AbstractBackgroundTaskRunner
implements BackgroundTaskRunner {
    protected abstract BackgroundTaskWorker getBackgroundTaskWorker(Task var1);

    @Override
    public void run(Task task) throws Exception {
        this.getBackgroundTaskWorker(task).run();
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
    }

    protected static class BackgroundTaskWorker {
        protected final Task task;
        protected final TaskDetails taskDetails;

        public BackgroundTaskWorker(Task task) {
            this.task = task;
            this.taskDetails = task.getTaskDetails();
        }

        public void run() throws Exception {
            Class<?> taskToPerformClass = this.getTaskToPerformClass();
            Object taskToPerform = this.getTaskToPerform(taskToPerformClass);
            Method taskMethodToPerform = this.getTaskMethodToPerform(taskToPerformClass);
            this.invokeTaskMethod(taskToPerform, taskMethodToPerform);
        }

        protected Class<?> getTaskToPerformClass() {
            return TaskUtils.getTaskClass(this.taskDetails);
        }

        protected Object getTaskToPerform(Class<?> taskToPerformClass) {
            return ReflectionUtils.newInstance(taskToPerformClass);
        }

        protected Method getTaskMethodToPerform(Class<?> taskToPerformClass) {
            return TaskUtils.getTaskMethod(taskToPerformClass, this.taskDetails);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void invokeTaskMethod(Object taskToPerform, Method taskMethodToPerform) throws Exception {
            Object[] taskParameterValues = this.taskDetails.getTaskParameterValues();
            List<TaskParameter> taskParameters = this.taskDetails.getTaskParameters();
            IntStream.range(0, taskParameters.size()).filter(i -> ((TaskParameter)taskParameters.get(i)).getClassName().equals(TaskContext.class.getName())).findFirst().ifPresent(index -> {
                taskParameterValues[index] = this.getRunnerTaskContext();
            });
            try {
                ThreadLocalTaskContext.setTaskContext(this.getRunnerTaskContext());
                taskMethodToPerform.invoke(taskToPerform, taskParameterValues);
            }
            finally {
                ThreadLocalTaskContext.clear();
            }
        }

        protected RunnerTaskContext getRunnerTaskContext() {
            return new RunnerTaskContext(this.task);
        }
    }
}

