/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.server.runner.AbstractBackgroundTaskRunner;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class BackgroundStaticFieldTaskWithoutIocRunner
extends AbstractBackgroundTaskRunner {
    @Override
    public boolean supports(Task task) {
        TaskDetails taskDetails = task.getTaskDetails();
        return taskDetails.hasStaticFieldName();
    }

    @Override
    protected AbstractBackgroundTaskRunner.BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
        return new StaticFieldBackgroundTaskWorker(task);
    }

    protected static class StaticFieldBackgroundTaskWorker
    extends AbstractBackgroundTaskRunner.BackgroundTaskWorker {
        public StaticFieldBackgroundTaskWorker(Task task) {
            super(task);
        }

        @Override
        public void run() throws Exception {
            Class<?> taskContainingStaticFieldClass = this.getTaskToPerformClass();
            Field taskField = this.getStaticFieldOfTaskToPerformClass(taskContainingStaticFieldClass);
            Class<?> taskToPerformClass = taskField.getType();
            Method methodToPerform = this.getTaskMethodToPerform(taskToPerformClass);
            this.invokeTaskMethod(taskField.get(null), methodToPerform);
        }

        private Field getStaticFieldOfTaskToPerformClass(Class<?> taskContainingStaticFieldClass) throws NoSuchFieldException {
            String staticFieldName = this.taskDetails.getStaticFieldName();
            return taskContainingStaticFieldClass.getDeclaredField(staticFieldName);
        }
    }
}

