/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.runner;

import cn.boboweike.carrot.server.TaskActivator;
import cn.boboweike.carrot.server.runner.AbstractBackgroundTaskRunner;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;

public class BackgroundTaskWithIocRunner
extends AbstractBackgroundTaskRunner {
    private final TaskActivator taskActivator;

    public BackgroundTaskWithIocRunner(TaskActivator taskActivator) {
        this.taskActivator = taskActivator;
    }

    @Override
    public boolean supports(Task task) {
        if (this.taskActivator == null) {
            return false;
        }
        TaskDetails taskDetails = task.getTaskDetails();
        return !taskDetails.hasStaticFieldName() && this.taskActivator.activateTask(ReflectionUtils.toClass(taskDetails.getClassName())) != null;
    }

    @Override
    protected AbstractBackgroundTaskRunner.BackgroundTaskWorker getBackgroundTaskWorker(Task task) {
        return new BackgroundForIoCTaskLambdaWorker(this.taskActivator, task);
    }

    protected static class BackgroundForIoCTaskLambdaWorker
    extends AbstractBackgroundTaskRunner.BackgroundTaskWorker {
        private final TaskActivator taskActivator;

        public BackgroundForIoCTaskLambdaWorker(TaskActivator taskActivator, Task task) {
            super(task);
            this.taskActivator = taskActivator;
        }

        @Override
        protected Object getTaskToPerform(Class<?> taskToPerformClass) {
            return this.taskActivator.activateTask(taskToPerformClass);
        }
    }
}

