/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.tasks;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.CollectionUtils;
import cn.boboweike.carrot.utils.TaskUtils;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckIfAllTasksExistTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(BackgroundTaskServer.class);
    private final PartitionedStorageProvider storageProvider;

    public CheckIfAllTasksExistTask(BackgroundTaskServer backgroundTaskServer) {
        this.storageProvider = backgroundTaskServer.getStorageProvider();
    }

    @Override
    public void run() {
        try {
            Set<String> distinctRecurringTaskSignatures = this.getDistinctRecurringTaskSignaturesThatDoNotExistAnymore();
            Set<String> distinctScheduledTaskSignatures = this.getDistinctScheduledTaskSignaturesThatDoNotExistAnymore();
            Set tasksThatCannotBeFound = CollectionUtils.asSet(new Collection[]{distinctRecurringTaskSignatures, distinctScheduledTaskSignatures});
            if (!distinctRecurringTaskSignatures.isEmpty() || !distinctScheduledTaskSignatures.isEmpty()) {
                String taskStateThatIsNotFound = this.taskTypeNotFoundLabel(distinctRecurringTaskSignatures, distinctScheduledTaskSignatures);
                LOGGER.warn("Carrot found {} tasks that do not exist anymore in your code. These tasks will fail with a TaskNotFoundException (due to a ClassNotFoundException or a MethodNotFoundException).\n\tBelow you can find the method signatures of the tasks that cannot be found anymore: {}", (Object)taskStateThatIsNotFound, (Object)tasksThatCannotBeFound.stream().map(sign -> "\n\t" + sign + ",").collect(Collectors.joining()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception running `CheckIfAllTasksExistTask`", (Throwable)CarrotException.shouldNotHappenException(e));
        }
    }

    private Set<String> getDistinctRecurringTaskSignaturesThatDoNotExistAnymore() {
        return this.storageProvider.getRecurringTasks().stream().map(AbstractTask::getTaskSignature).filter(taskSignature -> !TaskUtils.taskExists(taskSignature)).collect(Collectors.toSet());
    }

    private Set<String> getDistinctScheduledTaskSignaturesThatDoNotExistAnymore() {
        return this.storageProvider.getDistinctTaskSignatures(StateName.SCHEDULED).stream().filter(taskSignature -> !TaskUtils.taskExists(taskSignature)).collect(Collectors.toSet());
    }

    private String taskTypeNotFoundLabel(Set<String> distinctRecurringTaskSignaturesThatDoNotExistAnymoreAfterCleanup, Set<String> distinctScheduledTaskSignaturesThatDoNotExistAnymoreAfterCleanup) {
        Object taskStateThatIsNotFound = "";
        if (!distinctRecurringTaskSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            taskStateThatIsNotFound = (String)taskStateThatIsNotFound + "RECURRING";
        }
        if (!distinctRecurringTaskSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty() && !distinctScheduledTaskSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            taskStateThatIsNotFound = (String)taskStateThatIsNotFound + " AND ";
        }
        if (!distinctScheduledTaskSignaturesThatDoNotExistAnymoreAfterCleanup.isEmpty()) {
            taskStateThatIsNotFound = (String)taskStateThatIsNotFound + "SCHEDULED";
        }
        return taskStateThatIsNotFound;
    }
}

