/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.server.threadpool;

import cn.boboweike.carrot.server.threadpool.CarrotExecutor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledThreadPoolCarrotExecutor
extends ScheduledThreadPoolExecutor
implements CarrotExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledThreadPoolCarrotExecutor.class);

    public ScheduledThreadPoolCarrotExecutor(int corePoolSize, String threadNamePrefix) {
        super(corePoolSize, new NamedThreadFactory(threadNamePrefix));
        this.setMaximumPoolSize(corePoolSize * 2);
        this.setKeepAliveTime(1L, TimeUnit.MINUTES);
    }

    @Override
    public int getPriority() {
        return 10;
    }

    @Override
    public void start() {
        this.prestartAllCoreThreads();
        LOGGER.info("ThreadManager of type 'ScheduledThreadPool' started");
    }

    @Override
    public void stop() {
        this.shutdown();
        try {
            if (!this.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final String poolName;
        private final ThreadFactory threadFactory;

        public NamedThreadFactory(String poolName) {
            this.poolName = poolName;
            this.threadFactory = Executors.defaultThreadFactory();
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.threadFactory.newThread(runnable);
            thread.setName(thread.getName().replace("pool", this.poolName));
            return thread;
        }
    }
}

