/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.TaskStatsEnricher;
import cn.boboweike.carrot.storage.TaskStatsExtended;
import cn.boboweike.carrot.storage.listeners.BackgroundTaskServerStatusChangeListener;
import cn.boboweike.carrot.storage.listeners.MetadataChangeListener;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.storage.listeners.TaskChangeListener;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.utils.resilience.RateLimiter;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPartitionedStorageProvider
implements PartitionedStorageProvider,
AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPartitionedStorageProvider.class);
    private final Set<StorageProviderChangeListener> onChangeListeners = ConcurrentHashMap.newKeySet();
    private final TaskStatsEnricher taskStatsEnricher = new TaskStatsEnricher();
    private final RateLimiter changeListenerNotificationRateLimit;
    private final ReentrantLock reentrantLock;
    private volatile Timer timer;

    protected AbstractPartitionedStorageProvider(RateLimiter changeListenerNotificationRateLimit) {
        this.changeListenerNotificationRateLimit = changeListenerNotificationRateLimit;
        this.reentrantLock = new ReentrantLock();
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void addTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.add(listener);
        this.startTimerToSendUpdates();
    }

    @Override
    public void removeTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.onChangeListeners.remove(listener);
        if (this.onChangeListeners.isEmpty()) {
            this.stopTimerToSendUpdates();
        }
    }

    @Override
    public void close() {
        this.stopTimerToSendUpdates();
    }

    protected void notifyTaskStatsOnChangeListenersIf(boolean mustNotify) {
        if (mustNotify) {
            this.notifyTaskStatsOnChangeListeners();
        }
    }

    protected void notifyTaskStatsOnChangeListeners() {
        try {
            if (this.changeListenerNotificationRateLimit.isRateLimited()) {
                return;
            }
            List<TaskStatsChangeListener> taskStatsChangeListeners = StreamUtils.ofType(this.onChangeListeners, TaskStatsChangeListener.class).collect(Collectors.toList());
            if (!taskStatsChangeListeners.isEmpty()) {
                TaskStatsData taskStatsData = this.getTaskStatsData();
                TaskStats taskStats = taskStatsData.getOverallTaskStats();
                TaskStatsExtended taskStatsExtended = this.taskStatsEnricher.enrich(taskStats);
                taskStatsData.setOverallTaskStats(taskStatsExtended);
                taskStatsChangeListeners.forEach(listener -> listener.onChange(taskStatsData));
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    protected void notifyMetadataChangeListeners(boolean mustNotify) {
        if (mustNotify) {
            this.notifyMetadataChangeListeners();
        }
    }

    protected void notifyMetadataChangeListeners() {
        try {
            Map<String, List<MetadataChangeListener>> metadataChangeListenersByName = StreamUtils.ofType(this.onChangeListeners, MetadataChangeListener.class).collect(Collectors.groupingBy(MetadataChangeListener::listenForChangesOfMetadataName));
            if (!metadataChangeListenersByName.isEmpty()) {
                metadataChangeListenersByName.forEach((metadataName, listeners) -> {
                    List<CarrotMetadata> carrotMetadata = this.getMetadata((String)metadataName);
                    listeners.forEach(listener -> listener.onChange(carrotMetadata));
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyTaskChangeListeners() {
        try {
            Map<TaskId, List<TaskChangeListener>> listenerByTask = StreamUtils.ofType(this.onChangeListeners, TaskChangeListener.class).collect(Collectors.groupingBy(TaskChangeListener::getTaskId));
            if (!listenerByTask.isEmpty()) {
                listenerByTask.forEach((taskId, listeners) -> {
                    try {
                        Task task = this.getTaskById((TaskId)taskId);
                        listeners.forEach(listener -> listener.onChange(task));
                    }
                    catch (TaskNotFoundException taskNotFoundException) {
                        listeners.forEach(taskChangeListener -> {
                            try {
                                taskChangeListener.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        });
                    }
                });
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    private void notifyBackgroundTaskServerStatusChangeListeners() {
        try {
            List<BackgroundTaskServerStatusChangeListener> serverChangeListeners = StreamUtils.ofType(this.onChangeListeners, BackgroundTaskServerStatusChangeListener.class).collect(Collectors.toList());
            if (!serverChangeListeners.isEmpty()) {
                List<BackgroundTaskServerStatus> servers = this.getBackgroundTaskServers();
                serverChangeListeners.forEach(listener -> listener.onChange(servers));
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    void startTimerToSendUpdates() {
        if (this.timer == null) {
            try {
                if (this.reentrantLock.tryLock()) {
                    this.timer = new Timer(true);
                    this.timer.schedule((TimerTask)new NotifyOnChangeListeners(), 3000L, 5000L);
                }
            }
            finally {
                this.reentrantLock.unlock();
            }
        }
    }

    void stopTimerToSendUpdates() {
        if (this.timer != null) {
            boolean canCancelTimer;
            boolean bl = canCancelTimer = this.timer != null && this.reentrantLock.tryLock();
            if (canCancelTimer) {
                this.timer.cancel();
                this.timer = null;
                this.reentrantLock.unlock();
            }
        }
    }

    private void logError(Exception e) {
        if (this.reentrantLock.isLocked() || this.timer == null) {
            return;
        }
        LOGGER.warn("Error notifying TaskStorageChangeListeners", (Throwable)e);
    }

    class NotifyOnChangeListeners
    extends TimerTask {
        NotifyOnChangeListeners() {
        }

        @Override
        public void run() {
            AbstractPartitionedStorageProvider.this.notifyTaskStatsOnChangeListeners();
            AbstractPartitionedStorageProvider.this.notifyTaskChangeListeners();
            AbstractPartitionedStorageProvider.this.notifyBackgroundTaskServerStatusChangeListeners();
            AbstractPartitionedStorageProvider.this.notifyMetadataChangeListeners();
        }
    }
}

