/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import java.time.Instant;
import java.util.UUID;

public class CarrotMetadata {
    private final String name;
    private final String owner;
    private final Instant createdAt;
    private final Instant updatedAt;
    private String value;

    public CarrotMetadata(String name, String owner, Object value) {
        this(name, owner, value.toString());
    }

    public CarrotMetadata(String name, String owner, String value) {
        this(name, owner, value, Instant.now(), Instant.now());
    }

    public CarrotMetadata(String name, String owner, String value, Instant createdAt, Instant updatedAt) {
        this.name = name;
        this.owner = owner;
        this.value = value;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
    }

    public String getId() {
        return CarrotMetadata.toId(this.name, this.owner);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Long getValueAsLong() {
        return Long.parseLong(this.value);
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public static String toId(String name, String owner) {
        return name.replace(" ", "_") + "-" + owner.replace(" ", "_");
    }

    public static String toId(String name, UUID owner) {
        return CarrotMetadata.toId(name, owner.toString());
    }
}

