/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.storage.StorageException;
import cn.boboweike.carrot.tasks.Task;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ConcurrentTaskModificationException
extends StorageException {
    private final List<Task> concurrentUpdatedTasks;

    public ConcurrentTaskModificationException(Task concurrentUpdatedTask) {
        this(Collections.singletonList(concurrentUpdatedTask));
    }

    public ConcurrentTaskModificationException(List<Task> concurrentUpdatedTasks) {
        super("The following tasks where concurrently updated: " + concurrentUpdatedTasks.stream().map(task -> task.getId().toString()).collect(Collectors.joining(", ")));
        this.concurrentUpdatedTasks = concurrentUpdatedTasks;
    }

    public List<Task> getConcurrentUpdatedTasks() {
        return this.concurrentUpdatedTasks;
    }
}

