/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.lock.LockProvider;
import cn.boboweike.carrot.lock.inmemory.InMemoryLockProvider;
import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.storage.AbstractPartitionedStorageProvider;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.ServerTimedOutException;
import cn.boboweike.carrot.storage.StorageException;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskVersioner;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.resilience.RateLimiter;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InMemoryPartitionedStorageProvider
extends AbstractPartitionedStorageProvider {
    private final Map<UUID, Task> taskQueue = new ConcurrentHashMap<UUID, Task>();
    private final Map<UUID, BackgroundTaskServerStatus> backgroundTaskServers = new ConcurrentHashMap<UUID, BackgroundTaskServerStatus>();
    private final List<RecurringTask> recurringTasks = new CopyOnWriteArrayList<RecurringTask>();
    private final Map<String, CarrotMetadata> metadata = new ConcurrentHashMap<String, CarrotMetadata>();
    private final LockProvider lockProvider = new InMemoryLockProvider();
    private TaskMapper taskMapper;

    public InMemoryPartitionedStorageProvider() {
        this(RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND));
    }

    protected InMemoryPartitionedStorageProvider(RateLimiter rateLimiter) {
        super(rateLimiter);
        this.publishTotalAmountOfSucceededTasks(0);
    }

    @Override
    public int getTotalNumOfPartitions() {
        return 1;
    }

    @Override
    public boolean lockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.lockProvider.lock("partition_" + partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean extendLockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.lockProvider.extend("partition_" + partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean unlockByPartition(Integer partition) {
        return this.lockProvider.unlock("partition_" + partition);
    }

    @Override
    public void setTaskMapper(TaskMapper taskMapper) {
        this.taskMapper = taskMapper;
    }

    @Override
    public void setPartitioner(Partitioner partitioner) {
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
    }

    @Override
    public void announceBackgroundTaskServer(BackgroundTaskServerStatus serverStatus) {
        BackgroundTaskServerStatus backgroundTaskServerStatus = new BackgroundTaskServerStatus(serverStatus.getId(), serverStatus.getWorkerPoolSize(), serverStatus.getPollIntervalInSeconds(), serverStatus.getDeleteSucceededTasksAfter(), serverStatus.getPermanentlyDeleteDeletedTasksAfter(), serverStatus.getFirstHeartbeat(), serverStatus.getLastHeartbeat(), serverStatus.isRunning(), serverStatus.getSystemTotalMemory(), serverStatus.getSystemFreeMemory(), serverStatus.getSystemCpuLoad(), serverStatus.getProcessMaxMemory(), serverStatus.getProcessFreeMemory(), serverStatus.getProcessAllocatedMemory(), serverStatus.getProcessCpuLoad(), serverStatus.getPartition());
        this.backgroundTaskServers.put(serverStatus.getId(), backgroundTaskServerStatus);
    }

    @Override
    public boolean signalBackgroundTaskServerAlive(BackgroundTaskServerStatus serverStatus) {
        if (!this.backgroundTaskServers.containsKey(serverStatus.getId())) {
            throw new ServerTimedOutException(serverStatus, new StorageException("The server is not there"));
        }
        this.announceBackgroundTaskServer(serverStatus);
        BackgroundTaskServerStatus backgroundTaskServerStatus = this.backgroundTaskServers.get(serverStatus.getId());
        return backgroundTaskServerStatus.isRunning();
    }

    @Override
    public void signalBackgroundTaskServerStopped(BackgroundTaskServerStatus serverStatus) {
        this.backgroundTaskServers.remove(serverStatus.getId());
    }

    @Override
    public List<BackgroundTaskServerStatus> getBackgroundTaskServers() {
        return this.backgroundTaskServers.values().stream().sorted(Comparator.comparing(BackgroundTaskServerStatus::getFirstHeartbeat)).collect(Collectors.toList());
    }

    @Override
    public UUID getLongestRunningBackgroundTaskServerId() {
        return this.backgroundTaskServers.values().stream().min(Comparator.comparing(BackgroundTaskServerStatus::getFirstHeartbeat)).map(BackgroundTaskServerStatus::getId).orElseThrow(() -> new IllegalStateException("No servers available!"));
    }

    @Override
    public int removeTimedOutBackgroundTaskServers(Instant heartbeatOlderThan) {
        List serversToRemove = this.backgroundTaskServers.entrySet().stream().filter(entry -> ((BackgroundTaskServerStatus)entry.getValue()).getLastHeartbeat().isBefore(heartbeatOlderThan)).map(Map.Entry::getKey).collect(Collectors.toList());
        this.backgroundTaskServers.keySet().removeAll(serversToRemove);
        return serversToRemove.size();
    }

    @Override
    public void saveMetadata(CarrotMetadata metadata) {
        this.metadata.put(metadata.getName() + "-" + metadata.getOwner(), metadata);
        this.notifyMetadataChangeListeners();
    }

    @Override
    public List<CarrotMetadata> getMetadata(String name) {
        return this.metadata.values().stream().filter(m -> m.getName().equals(name)).collect(Collectors.toList());
    }

    @Override
    public CarrotMetadata getMetadata(String name, String owner) {
        return this.metadata.get(name + "-" + owner);
    }

    @Override
    public void deleteMetadata(String name) {
        List metadataToRemove = this.metadata.values().stream().filter(metadata -> metadata.getName().equals(name)).map(CarrotMetadata::getId).collect(Collectors.toList());
        if (!metadataToRemove.isEmpty()) {
            this.metadata.keySet().removeAll(metadataToRemove);
            this.notifyMetadataChangeListeners();
        }
    }

    @Override
    public Task save(Task task) {
        this.saveTask(task);
        this.notifyTaskStatsOnChangeListeners();
        return task;
    }

    @Override
    public Task saveByPartition(Task task, Integer partition) {
        return this.save(task);
    }

    @Override
    public int deletePermanentlyByPartition(UUID id, Integer partition) {
        boolean removed = this.taskQueue.keySet().remove(id);
        this.notifyTaskStatsOnChangeListenersIf(removed);
        return removed ? 1 : 0;
    }

    @Override
    public Task getTaskById(UUID id) {
        if (!this.taskQueue.containsKey(id)) {
            throw new TaskNotFoundException(id);
        }
        return this.deepClone(this.taskQueue.get(id));
    }

    @Override
    public List<Task> save(List<Task> tasks) {
        List<Task> concurrentModifiedTasks = StorageProviderUtils.returnConcurrentModifiedTasks(tasks, this::saveTask);
        if (!concurrentModifiedTasks.isEmpty()) {
            throw new ConcurrentTaskModificationException(concurrentModifiedTasks);
        }
        this.notifyTaskStatsOnChangeListeners();
        return tasks;
    }

    @Override
    public List<Task> saveByPartition(List<Task> tasks, Integer partition) {
        return this.save(tasks);
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, Instant updatedBefore, PageRequest pageRequest, Integer partition) {
        return this.getTasksStream(state, pageRequest).filter(task -> task.getUpdatedAt().isBefore(updatedBefore)).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public List<Task> getScheduledTasksByPartition(Instant scheduledBefore, PageRequest pageRequest, Integer partition) {
        return this.getTasksStream(StateName.SCHEDULED, pageRequest).filter(task -> ((ScheduledState)task.getTaskState()).getScheduledAt().isBefore(scheduledBefore)).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.getTasksStream(state, pageRequest).skip(pageRequest.getOffset()).limit(pageRequest.getLimit()).map(this::deepClone).collect(Collectors.toList());
    }

    @Override
    public Page<Task> getTaskPageByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return new Page<Task>(this.getTasksStream(state).count(), this.getTasksByPartition(state, pageRequest, partition), pageRequest);
    }

    @Override
    public int deleteTasksPermanentlyByPartition(StateName state, Instant updatedBefore, Integer partition) {
        List tasksToRemove = this.taskQueue.values().stream().filter(task -> task.hasState(state)).filter(task -> task.getUpdatedAt().isBefore(updatedBefore)).map(Task::getId).collect(Collectors.toList());
        this.taskQueue.keySet().removeAll(tasksToRemove);
        this.notifyTaskStatsOnChangeListenersIf(!tasksToRemove.isEmpty());
        return tasksToRemove.size();
    }

    @Override
    public Set<String> getDistinctTaskSignatures(StateName ... states) {
        return this.taskQueue.values().stream().filter(task -> Arrays.asList(states).contains((Object)task.getState())).map(AbstractTask::getTaskSignature).collect(Collectors.toSet());
    }

    @Override
    public boolean existsByPartition(TaskDetails taskDetails, Integer partition, StateName ... states) {
        String actualTaskSignature = TaskUtils.getTaskSignature(taskDetails);
        return this.taskQueue.values().stream().anyMatch(task -> Arrays.asList(states).contains((Object)task.getState()) && actualTaskSignature.equals(TaskUtils.getTaskSignature(task.getTaskDetails())));
    }

    @Override
    public boolean recurringTaskExistsByPartition(String recurringTaskId, Integer partition, StateName ... states) {
        return this.taskQueue.values().stream().anyMatch(task -> Arrays.asList(states).contains((Object)task.getState()) && task.getRecurringTaskId().map(actualRecurringTaskId -> actualRecurringTaskId.equals(recurringTaskId)).orElse(false) != false);
    }

    @Override
    public RecurringTask saveRecurringTask(RecurringTask recurringTask) {
        this.deleteRecurringTask(recurringTask.getId());
        this.recurringTasks.add(recurringTask);
        return recurringTask;
    }

    @Override
    public List<RecurringTask> getRecurringTasksByPartition(Integer partition) {
        return this.recurringTasks;
    }

    @Override
    public List<RecurringTask> getRecurringTasks() {
        return this.recurringTasks;
    }

    @Override
    public long countRecurringTasksByPartition(Integer partition) {
        return this.recurringTasks.size();
    }

    @Override
    public int deleteRecurringTask(String id) {
        this.recurringTasks.removeIf(task -> id.equals(task.getId()));
        return 0;
    }

    @Override
    public TaskStatsData getTaskStatsData() {
        TaskStats taskStats = new TaskStats(Instant.now(), Long.valueOf(this.taskQueue.size()), this.getTasksStream(StateName.SCHEDULED).count(), this.getTasksStream(StateName.ENQUEUED).count(), this.getTasksStream(StateName.PROCESSING).count(), this.getTasksStream(StateName.FAILED).count(), this.getTasksStream(StateName.SUCCEEDED).count(), this.getMetadata("succeeded-tasks-counter", "cluster").getValueAsLong(), this.getTasksStream(StateName.DELETED).count(), this.recurringTasks.size(), this.backgroundTaskServers.size());
        TaskStatsData taskStatsData = new TaskStatsData();
        taskStatsData.setOverallTaskStats(taskStats);
        taskStatsData.getTaskStatsList().add(taskStats);
        return taskStatsData;
    }

    @Override
    public void publishTotalAmountOfSucceededTasks(int amount) {
        CarrotMetadata metadata = this.metadata.computeIfAbsent("succeeded-tasks-counter-cluster", input -> new CarrotMetadata("succeeded-tasks-counter", "cluster", new AtomicLong(0L).toString()));
        metadata.setValue(new AtomicLong(Long.parseLong(metadata.getValue()) + (long)amount).toString());
    }

    private Stream<Task> getTasksStream(StateName state, PageRequest pageRequest) {
        return this.getTasksStream(state).sorted(this.getTaskComparator(pageRequest));
    }

    private Stream<Task> getTasksStream(StateName state) {
        return this.taskQueue.values().stream().filter(task -> task.hasState(state));
    }

    private synchronized void saveTask(Task task) {
        Task oldTask = this.taskQueue.get(task.getId());
        if (oldTask != null && task.getVersion() != oldTask.getVersion()) {
            throw new ConcurrentTaskModificationException(task);
        }
        try (TaskVersioner taskVersioner = new TaskVersioner(task);){
            this.taskQueue.put(task.getId(), this.deepClone(task));
            taskVersioner.commitVersion();
        }
    }

    private Task deepClone(Task task) {
        String serializedTaskAsString = this.taskMapper.serializeTask(task);
        Task result = this.taskMapper.deserializeTask(serializedTaskAsString);
        ReflectionUtils.setFieldUsingAutoboxing("locker", (Object)result, ReflectionUtils.getValueFromFieldOrProperty(task, "locker"));
        return result;
    }

    private Comparator<Task> getTaskComparator(PageRequest pageRequest) {
        String[] sortOns;
        ArrayList<Comparator<Task>> result = new ArrayList<Comparator<Task>>();
        for (String sortOn : sortOns = pageRequest.getOrder().split(",")) {
            String[] sortAndOrder = sortOn.split(":");
            String sortField = sortAndOrder[0];
            PageRequest.Order order = PageRequest.Order.ASC;
            if (sortAndOrder.length > 1) {
                order = PageRequest.Order.valueOf(sortAndOrder[1].toUpperCase());
            }
            Comparator<Task> comparator = null;
            if (sortField.equalsIgnoreCase("createdAt")) {
                comparator = Comparator.comparing(Task::getCreatedAt);
            } else if (sortField.equalsIgnoreCase("updatedAt")) {
                comparator = Comparator.comparing(Task::getUpdatedAt);
            } else {
                throw new IllegalStateException("An unsupported sortOrder was requested: " + sortField);
            }
            if (order == PageRequest.Order.DESC) {
                comparator = comparator.reversed();
            }
            result.add(comparator);
        }
        return result.stream().reduce(Comparator::thenComparing).orElse((a, b) -> 0);
    }
}

