/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.storage.PageRequest;
import java.util.ArrayList;
import java.util.List;

public class Page<T> {
    private final long total;
    private final long offset;
    private final int limit;
    private final ArrayList<T> items;
    private final int currentPage;
    private final int totalPages;
    private final boolean hasPrevious;
    private final boolean hasNext;

    public Page(long total, List<T> items, PageRequest pageRequest) {
        this(total, items, pageRequest.getOffset(), pageRequest.getLimit());
    }

    public Page(long total, List<T> items, long offset, int limit) {
        this.total = total;
        this.items = new ArrayList<T>(items);
        this.offset = offset;
        this.limit = limit;
        this.currentPage = this.calculateCurrentPage();
        this.totalPages = this.calculateTotalPages();
        this.hasPrevious = offset > 0L;
        this.hasNext = offset + (long)limit < total;
    }

    public long getTotal() {
        return this.total;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<T> getItems() {
        return this.items;
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public boolean hasPrevious() {
        return this.hasPrevious;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    private int calculateCurrentPage() {
        int result = (int)Math.floor((double)this.offset / (double)this.limit);
        if (result < 1 && this.offset > 0L) {
            return 1;
        }
        return result;
    }

    private int calculateTotalPages() {
        int result = (int)Math.ceil((double)this.total / (double)this.limit);
        if ((long)(result * this.limit) < this.total) {
            ++result;
        }
        return result;
    }
}

