/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskId;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.StateName;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public interface PartitionedStorageProvider {
    public static final int BATCH_SIZE = 5000;
    public static final int DEFAULT_NUM_OF_PARTITIONS = 1;
    public static final String PARTITION_PREFIX = "partition_";
    public static final String PARTITION_HINT_KEY = "partition_hint_key";

    public String getName();

    public int getTotalNumOfPartitions();

    public boolean lockByPartition(Integer var1, int var2, String var3);

    public boolean extendLockByPartition(Integer var1, int var2, String var3);

    public boolean unlockByPartition(Integer var1);

    public void setTaskMapper(TaskMapper var1);

    public void setPartitioner(Partitioner var1);

    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions var1);

    public void addTaskStorageOnChangeListener(StorageProviderChangeListener var1);

    public void removeTaskStorageOnChangeListener(StorageProviderChangeListener var1);

    public void announceBackgroundTaskServer(BackgroundTaskServerStatus var1);

    public boolean signalBackgroundTaskServerAlive(BackgroundTaskServerStatus var1);

    public void signalBackgroundTaskServerStopped(BackgroundTaskServerStatus var1);

    public List<BackgroundTaskServerStatus> getBackgroundTaskServers();

    public UUID getLongestRunningBackgroundTaskServerId();

    public int removeTimedOutBackgroundTaskServers(Instant var1);

    public void saveMetadata(CarrotMetadata var1);

    public List<CarrotMetadata> getMetadata(String var1);

    public CarrotMetadata getMetadata(String var1, String var2);

    public void deleteMetadata(String var1);

    public Task save(Task var1);

    public Task saveByPartition(Task var1, Integer var2);

    public int deletePermanentlyByPartition(UUID var1, Integer var2);

    public Task getTaskById(UUID var1);

    public List<Task> save(List<Task> var1);

    public List<Task> saveByPartition(List<Task> var1, Integer var2);

    public List<Task> getTasksByPartition(StateName var1, Instant var2, PageRequest var3, Integer var4);

    public List<Task> getScheduledTasksByPartition(Instant var1, PageRequest var2, Integer var3);

    public List<Task> getTasksByPartition(StateName var1, PageRequest var2, Integer var3);

    public Page<Task> getTaskPageByPartition(StateName var1, PageRequest var2, Integer var3);

    public int deleteTasksPermanentlyByPartition(StateName var1, Instant var2, Integer var3);

    public Set<String> getDistinctTaskSignatures(StateName ... var1);

    public boolean existsByPartition(TaskDetails var1, Integer var2, StateName ... var3);

    public boolean recurringTaskExistsByPartition(String var1, Integer var2, StateName ... var3);

    public RecurringTask saveRecurringTask(RecurringTask var1);

    public List<RecurringTask> getRecurringTasksByPartition(Integer var1);

    public List<RecurringTask> getRecurringTasks();

    public long countRecurringTasksByPartition(Integer var1);

    public int deleteRecurringTask(String var1);

    public TaskStatsData getTaskStatsData();

    public void publishTotalAmountOfSucceededTasks(int var1);

    default public Task getTaskById(TaskId taskId) {
        return this.getTaskById(taskId.asUUID());
    }

    public void close();
}

