/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsExtended;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.locks.ReentrantLock;

public class TaskStatsEnricher {
    private final ReentrantLock lock = new ReentrantLock();
    private TaskStats firstRelevantTaskStats;
    private TaskStats previousTaskStats;
    private TaskStatsExtended taskStatsExtended;

    public TaskStatsExtended enrich(TaskStats taskStats) {
        TaskStats latestTaskStats = TaskStatsEnricher.getLatestTaskStats(taskStats, this.previousTaskStats);
        if (this.lock.tryLock()) {
            this.setFirstRelevantTaskStats(latestTaskStats);
            this.setTaskStatsExtended(latestTaskStats);
            this.setPreviousTaskStats(latestTaskStats);
            this.lock.unlock();
        }
        return this.taskStatsExtended;
    }

    private static TaskStats getLatestTaskStats(TaskStats taskStats, TaskStats previousTaskStats) {
        if (previousTaskStats == null) {
            return taskStats;
        }
        if (taskStats.getTimeStamp().isAfter(previousTaskStats.getTimeStamp())) {
            return taskStats;
        }
        return previousTaskStats;
    }

    private void setFirstRelevantTaskStats(TaskStats taskStats) {
        if (this.firstRelevantTaskStats == null || taskStats.getEnqueued() < 1L && taskStats.getProcessing() < 1L || taskStats.getEnqueued() > this.firstRelevantTaskStats.getEnqueued()) {
            this.firstRelevantTaskStats = taskStats;
        }
    }

    private void setTaskStatsExtended(TaskStats taskStats) {
        TaskStats actualPreviousTaskStats = this.previousTaskStats != null ? this.previousTaskStats : this.firstRelevantTaskStats;
        Long amountSucceeded = taskStats.getSucceeded() - actualPreviousTaskStats.getSucceeded();
        Long amountFailed = taskStats.getFailed() - actualPreviousTaskStats.getFailed();
        Instant estimatedProcessingFinishedInstant = this.estimatedProcessingFinishedInstant(this.firstRelevantTaskStats, taskStats);
        this.taskStatsExtended = estimatedProcessingFinishedInstant != null ? new TaskStatsExtended(taskStats, amountSucceeded, amountFailed, estimatedProcessingFinishedInstant) : (this.taskStatsExtended != null && this.taskStatsExtended.getEstimation().isEstimatedProcessingFinishedInstantAvailable() ? new TaskStatsExtended(taskStats, amountSucceeded, amountFailed, this.taskStatsExtended.getEstimation().getEstimatedProcessingFinishedAt()) : new TaskStatsExtended(taskStats));
    }

    private Instant estimatedProcessingFinishedInstant(TaskStats firstRelevantTaskStats, TaskStats taskStats) {
        if (taskStats.getSucceeded() - firstRelevantTaskStats.getSucceeded() < 1L) {
            return null;
        }
        BigDecimal durationForAmountSucceededInSeconds = BigDecimal.valueOf(Duration.between(firstRelevantTaskStats.getTimeStamp(), taskStats.getTimeStamp()).getSeconds());
        if (BigDecimal.ZERO.equals(durationForAmountSucceededInSeconds)) {
            return null;
        }
        BigDecimal amountSucceededPerSecond = BigDecimal.valueOf(Math.ceil(taskStats.getSucceeded() - firstRelevantTaskStats.getSucceeded())).divide(durationForAmountSucceededInSeconds, RoundingMode.CEILING);
        if (BigDecimal.ZERO.equals(amountSucceededPerSecond)) {
            return null;
        }
        BigDecimal processingTimeInSeconds = BigDecimal.valueOf(taskStats.getEnqueued() + taskStats.getProcessing()).divide(amountSucceededPerSecond, RoundingMode.HALF_UP);
        return Instant.now().plusSeconds(processingTimeInSeconds.longValue());
    }

    private void setPreviousTaskStats(TaskStats taskStats) {
        this.previousTaskStats = taskStats;
    }
}

