/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage;

import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.StorageProviderChangeListener;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.resilience.Lock;
import cn.boboweike.carrot.utils.resilience.MultiLock;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import java.util.UUID;

public class ThreadSafePartitionedStorageProvider
implements PartitionedStorageProvider {
    private final PartitionedStorageProvider storageProvider;

    public ThreadSafePartitionedStorageProvider(PartitionedStorageProvider storageProvider) {
        this.storageProvider = storageProvider;
    }

    @Override
    public String getName() {
        return this.storageProvider.getName();
    }

    @Override
    public int getTotalNumOfPartitions() {
        return this.storageProvider.getTotalNumOfPartitions();
    }

    @Override
    public boolean lockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.storageProvider.lockByPartition(partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean extendLockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.storageProvider.extendLockByPartition(partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean unlockByPartition(Integer partition) {
        return this.storageProvider.unlockByPartition(partition);
    }

    @Override
    public void setTaskMapper(TaskMapper taskMapper) {
        this.storageProvider.setTaskMapper(taskMapper);
    }

    @Override
    public void setPartitioner(Partitioner partitioner) {
        this.storageProvider.setPartitioner(partitioner);
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        this.storageProvider.setUpStorageProvider(databaseOptions);
    }

    @Override
    public void addTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.addTaskStorageOnChangeListener(listener);
    }

    @Override
    public void removeTaskStorageOnChangeListener(StorageProviderChangeListener listener) {
        this.storageProvider.removeTaskStorageOnChangeListener(listener);
    }

    @Override
    public void announceBackgroundTaskServer(BackgroundTaskServerStatus serverStatus) {
        this.storageProvider.announceBackgroundTaskServer(serverStatus);
    }

    @Override
    public boolean signalBackgroundTaskServerAlive(BackgroundTaskServerStatus serverStatus) {
        return this.storageProvider.signalBackgroundTaskServerAlive(serverStatus);
    }

    @Override
    public void signalBackgroundTaskServerStopped(BackgroundTaskServerStatus serverStatus) {
        this.storageProvider.signalBackgroundTaskServerStopped(serverStatus);
    }

    @Override
    public List<BackgroundTaskServerStatus> getBackgroundTaskServers() {
        return this.storageProvider.getBackgroundTaskServers();
    }

    @Override
    public UUID getLongestRunningBackgroundTaskServerId() {
        return this.storageProvider.getLongestRunningBackgroundTaskServerId();
    }

    @Override
    public int removeTimedOutBackgroundTaskServers(Instant heartbeatOlderThan) {
        return this.storageProvider.removeTimedOutBackgroundTaskServers(heartbeatOlderThan);
    }

    @Override
    public void saveMetadata(CarrotMetadata metadata) {
        this.storageProvider.saveMetadata(metadata);
    }

    @Override
    public List<CarrotMetadata> getMetadata(String key) {
        return this.storageProvider.getMetadata(key);
    }

    @Override
    public CarrotMetadata getMetadata(String name, String owner) {
        return this.storageProvider.getMetadata(name, owner);
    }

    @Override
    public void deleteMetadata(String name) {
        this.storageProvider.deleteMetadata(name);
    }

    @Override
    public Task save(Task task) {
        try (Lock lock = task.lock();){
            Task task2 = this.storageProvider.save(task);
            return task2;
        }
    }

    @Override
    public Task saveByPartition(Task task, Integer partition) {
        try (Lock lock = task.lock();){
            Task task2 = this.storageProvider.saveByPartition(task, partition);
            return task2;
        }
    }

    @Override
    public int deletePermanentlyByPartition(UUID id, Integer partition) {
        return this.storageProvider.deletePermanentlyByPartition(id, partition);
    }

    @Override
    public Task getTaskById(UUID id) {
        return this.storageProvider.getTaskById(id);
    }

    @Override
    public List<Task> save(List<Task> tasks) {
        try (MultiLock lock = new MultiLock(tasks);){
            List<Task> list = this.storageProvider.save(tasks);
            return list;
        }
    }

    @Override
    public List<Task> saveByPartition(List<Task> tasks, Integer partition) {
        try (MultiLock lock = new MultiLock(tasks);){
            List<Task> list = this.storageProvider.saveByPartition(tasks, partition);
            return list;
        }
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, Instant updatedBefore, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTasksByPartition(state, updatedBefore, pageRequest, partition);
    }

    @Override
    public List<Task> getScheduledTasksByPartition(Instant scheduledBefore, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getScheduledTasksByPartition(scheduledBefore, pageRequest, partition);
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTasksByPartition(state, pageRequest, partition);
    }

    @Override
    public Page<Task> getTaskPageByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.storageProvider.getTaskPageByPartition(state, pageRequest, partition);
    }

    @Override
    public int deleteTasksPermanentlyByPartition(StateName state, Instant updatedBefore, Integer partition) {
        return this.storageProvider.deleteTasksPermanentlyByPartition(state, updatedBefore, partition);
    }

    @Override
    public Set<String> getDistinctTaskSignatures(StateName ... states) {
        return this.storageProvider.getDistinctTaskSignatures(states);
    }

    @Override
    public boolean existsByPartition(TaskDetails taskDetails, Integer partition, StateName ... states) {
        return this.storageProvider.existsByPartition(taskDetails, partition, states);
    }

    @Override
    public boolean recurringTaskExistsByPartition(String recurringTaskId, Integer partition, StateName ... states) {
        return this.storageProvider.recurringTaskExistsByPartition(recurringTaskId, partition, states);
    }

    @Override
    public RecurringTask saveRecurringTask(RecurringTask recurringTask) {
        return this.storageProvider.saveRecurringTask(recurringTask);
    }

    @Override
    public List<RecurringTask> getRecurringTasksByPartition(Integer partition) {
        return this.storageProvider.getRecurringTasksByPartition(partition);
    }

    @Override
    public List<RecurringTask> getRecurringTasks() {
        return this.storageProvider.getRecurringTasks();
    }

    @Override
    public long countRecurringTasksByPartition(Integer partition) {
        return this.storageProvider.countRecurringTasksByPartition(partition);
    }

    @Override
    public int deleteRecurringTask(String id) {
        return this.storageProvider.deleteRecurringTask(id);
    }

    @Override
    public TaskStatsData getTaskStatsData() {
        return this.storageProvider.getTaskStatsData();
    }

    @Override
    public void publishTotalAmountOfSucceededTasks(int amount) {
        this.storageProvider.publishTotalAmountOfSucceededTasks(amount);
    }

    @Override
    public void close() {
        this.storageProvider.close();
    }

    public PartitionedStorageProvider getStorageProvider() {
        return this.storageProvider;
    }
}

