/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.metrics;

import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.listeners.TaskStatsChangeListener;
import cn.boboweike.carrot.tasks.states.StateName;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import java.util.concurrent.atomic.AtomicLong;

public class StorageProviderMetricsBinder
implements TaskStatsChangeListener,
AutoCloseable {
    private final PartitionedStorageProvider storageProvider;
    private final MeterRegistry meterRegistry;
    private final AtomicLong scheduledGauge = new AtomicLong(0L);
    private final AtomicLong enqueuedGauge = new AtomicLong(0L);
    private final AtomicLong processingGauge = new AtomicLong(0L);
    private final AtomicLong failedGauge = new AtomicLong(0L);
    private final AtomicLong succeededGauge = new AtomicLong(0L);
    private final AtomicLong allTimeSucceededGauge = new AtomicLong(0L);
    private final AtomicLong deletedGauge = new AtomicLong(0L);

    public StorageProviderMetricsBinder(PartitionedStorageProvider storageProvider, MeterRegistry meterRegistry) {
        this.storageProvider = storageProvider;
        this.meterRegistry = meterRegistry;
        this.registerStorageProviderMetrics();
    }

    public void registerStorageProviderMetrics() {
        this.registerGauge(StateName.SCHEDULED, this.scheduledGauge);
        this.registerGauge(StateName.ENQUEUED, this.enqueuedGauge);
        this.registerGauge(StateName.PROCESSING, this.processingGauge);
        this.registerGauge(StateName.FAILED, this.failedGauge);
        this.registerGauge(StateName.SUCCEEDED, this.succeededGauge);
        this.registerGauge("ALL_TIME_SUCCEEDED", this.allTimeSucceededGauge);
        this.registerGauge(StateName.DELETED, this.deletedGauge);
        this.onChange(this.storageProvider.getTaskStatsData());
        this.storageProvider.addTaskStorageOnChangeListener(this);
    }

    private void registerGauge(StateName stateName, AtomicLong number) {
        this.registerGauge(stateName.toString(), number);
    }

    private void registerGauge(String stateName, AtomicLong number) {
        this.meterRegistry.gauge("carrot.tasks." + stateName.toLowerCase(), (Iterable)Tags.of((String)"state", (String)stateName), (Number)number);
    }

    @Override
    public void onChange(TaskStatsData taskStatsData) {
        TaskStats taskStats = taskStatsData.getOverallTaskStats();
        this.scheduledGauge.set(taskStats.getScheduled());
        this.enqueuedGauge.set(taskStats.getEnqueued());
        this.processingGauge.set(taskStats.getProcessing());
        this.failedGauge.set(taskStats.getFailed());
        this.succeededGauge.set(taskStats.getSucceeded());
        this.allTimeSucceededGauge.set(taskStats.getAllTimeSucceeded());
        this.deletedGauge.set(taskStats.getDeleted());
    }

    @Override
    public void close() {
        this.storageProvider.removeTaskStorageOnChangeListener(this);
    }
}

