/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.common;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.storage.nosql.common.migrations.NoSqlMigration;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NoSqlDatabaseCreator<T extends NoSqlMigration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NoSqlDatabaseCreator.class);
    private final List<T> migrations;

    protected NoSqlDatabaseCreator(List<T> migrations) {
        this.migrations = migrations;
    }

    public void runMigrations() {
        this.getMigrations().filter(this::isValidMigration).sorted(Comparator.comparing(m -> m.getClassName())).forEach(this::runMigrationIfNecessary);
    }

    protected boolean isValidMigration(T noSqlMigration) {
        return true;
    }

    protected abstract boolean isIncreasePartitions(T var1);

    protected abstract boolean isNewMigration(T var1);

    protected abstract void runMigration(T var1) throws Exception;

    protected abstract boolean markMigrationAsDone(T var1);

    protected void runMigrationIfNecessary(T noSqlMigration) {
        if (!this.isNewMigration(noSqlMigration) && !this.isIncreasePartitions(noSqlMigration)) {
            LOGGER.info("Skipping migration {} as it is already done", noSqlMigration);
        } else {
            LOGGER.info("Running migration {}", noSqlMigration);
            try {
                this.runMigration(noSqlMigration);
                this.markMigrationAsDone(noSqlMigration);
            }
            catch (Exception e) {
                throw CarrotException.shouldNotHappenException(new IllegalStateException("Error running database migration " + noSqlMigration.getClassName(), e));
            }
        }
    }

    protected Stream<T> getMigrations() {
        return this.migrations.stream();
    }
}

