/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.nosql.common.NoSqlDatabaseCreator;
import cn.boboweike.carrot.storage.nosql.mongo.MongoDBPartitionedStorageProvider;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M001_CreateTaskCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M002_CreateRecurringTaskCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M003_CreateMetadataCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M004_CreateBackgroundTaskServerCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.M005_CreateShedLockCollection;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.MongoMigration;
import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDBCreator
extends NoSqlDatabaseCreator<MongoMigration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MongoDBCreator.class);
    private final MongoDatabase carrotDatabase;
    private final String collectionPrefix;
    private final int numberOfPartitions;
    private final MongoCollection<Document> migrationCollection;

    public MongoDBCreator(MongoClient mongoClient, String dbName, int numberOfPartitions) {
        this(mongoClient, dbName, null, numberOfPartitions);
    }

    public MongoDBCreator(MongoClient mongoClient, String dbName, String collectionPrefix, int numberOfPartition) {
        super(Arrays.asList(new M001_CreateTaskCollection(), new M002_CreateRecurringTaskCollection(), new M003_CreateMetadataCollection(), new M004_CreateBackgroundTaskServerCollection(), new M005_CreateShedLockCollection()));
        this.carrotDatabase = mongoClient.getDatabase(dbName);
        this.collectionPrefix = collectionPrefix;
        this.migrationCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "migrations"));
        this.numberOfPartitions = numberOfPartition;
    }

    public void validateCollections() {
        List<String> requiredCollectionNames = Arrays.asList("tasks", "recurring_tasks");
        List availableCollectionNames = (List)this.carrotDatabase.listCollectionNames().into(new ArrayList());
        for (int partition = 0; partition < this.numberOfPartitions; ++partition) {
            for (String requiredCollectionName : requiredCollectionNames) {
                if (availableCollectionNames.contains(StorageProviderUtils.elementPrefixerWithPartition(this.collectionPrefix, requiredCollectionName, partition))) continue;
                throw new CarrotException("Not all required collections are available by Carrot!");
            }
        }
        if (!(availableCollectionNames.contains(StorageProviderUtils.elementPrefixer(this.collectionPrefix, "background_task_servers")) && availableCollectionNames.contains(StorageProviderUtils.elementPrefixer(this.collectionPrefix, "shed_lock")) && availableCollectionNames.contains(StorageProviderUtils.elementPrefixer(this.collectionPrefix, "metadata")))) {
            throw new CarrotException("Not all required collections are available by Carrot!");
        }
    }

    @Override
    protected boolean isIncreasePartitions(MongoMigration mongoMigration) {
        if (this.isNewMigration(mongoMigration)) {
            return false;
        }
        if (!mongoMigration.supportPartition()) {
            return false;
        }
        int oldNumberOfPartitions = this.getOldNumberOfPartitions(mongoMigration);
        if (this.numberOfPartitions > oldNumberOfPartitions) {
            return true;
        }
        if (this.numberOfPartitions == oldNumberOfPartitions) {
            return false;
        }
        throw new CarrotException(String.format("Carrot does not support decreasing the number of partitions, old = %s, new = %s!", oldNumberOfPartitions, this.numberOfPartitions));
    }

    private int getOldNumberOfPartitions(MongoMigration mongoMigration) {
        Document document = (Document)this.migrationCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)mongoMigration.getClassName())).first();
        if (document == null) {
            return -1;
        }
        int oldNumberOfPartitions = document.getInteger((Object)"num_of_partitions", -1);
        return oldNumberOfPartitions;
    }

    @Override
    protected boolean isNewMigration(MongoMigration mongoMigration) {
        Document document = (Document)this.migrationCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)mongoMigration.getClassName())).first();
        return document == null;
    }

    @Override
    protected void runMigration(MongoMigration mongoMigration) {
        if (mongoMigration.supportPartition()) {
            boolean increasePartitions = this.isIncreasePartitions(mongoMigration);
            int oldNumberOfPartitions = this.getOldNumberOfPartitions(mongoMigration);
            if (increasePartitions) {
                LOGGER.info("Increasing the number of partitions, old {}, new {}", (Object)oldNumberOfPartitions, (Object)this.numberOfPartitions);
            }
            for (int partition = 0; partition < this.numberOfPartitions; ++partition) {
                if (increasePartitions && partition < oldNumberOfPartitions) continue;
                mongoMigration.runMigration(this.carrotDatabase, this.collectionPrefix, partition);
            }
        } else {
            mongoMigration.runMigration(this.carrotDatabase, this.collectionPrefix, null);
        }
    }

    @Override
    protected boolean markMigrationAsDone(MongoMigration mongoMigration) {
        try {
            Document document = new Document();
            document.put(MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)mongoMigration.getClassName());
            document.put("name", (Object)mongoMigration.getClassName());
            document.put("date", (Object)Instant.now());
            if (mongoMigration.supportPartition()) {
                document.put("num_of_partitions", (Object)this.numberOfPartitions);
            }
            this.migrationCollection.findOneAndReplace(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)mongoMigration.getClassName()), (Object)document, new FindOneAndReplaceOptions().upsert(true));
            return true;
        }
        catch (MongoWriteException e) {
            if (e.getError().getCode() == 11000) {
                return true;
            }
            throw e;
        }
    }
}

