/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.lock.LockProvider;
import cn.boboweike.carrot.lock.nosql.MongoLockProvider;
import cn.boboweike.carrot.scheduling.partition.Partitioner;
import cn.boboweike.carrot.scheduling.partition.RandomPartitioner;
import cn.boboweike.carrot.storage.AbstractPartitionedStorageProvider;
import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.CarrotMetadata;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.storage.Page;
import cn.boboweike.carrot.storage.PageRequest;
import cn.boboweike.carrot.storage.PartitionedStorageProvider;
import cn.boboweike.carrot.storage.ServerTimedOutException;
import cn.boboweike.carrot.storage.StorageException;
import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.TaskNotFoundException;
import cn.boboweike.carrot.storage.TaskStats;
import cn.boboweike.carrot.storage.TaskStatsData;
import cn.boboweike.carrot.storage.nosql.mongo.MongoDBCreator;
import cn.boboweike.carrot.storage.nosql.mongo.MongoUtils;
import cn.boboweike.carrot.storage.nosql.mongo.mapper.BackgroundTaskServerStatusDocumentMapper;
import cn.boboweike.carrot.storage.nosql.mongo.mapper.MetadataDocumentMapper;
import cn.boboweike.carrot.storage.nosql.mongo.mapper.MongoDBPageRequestMapper;
import cn.boboweike.carrot.storage.nosql.mongo.mapper.TaskDocumentMapper;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskListVersioner;
import cn.boboweike.carrot.tasks.TaskVersioner;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.resilience.RateLimiter;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.MongoWriteException;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Accumulators;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.BsonField;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.Projections;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Sorts;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.UuidRepresentation;
import org.bson.codecs.Codec;
import org.bson.codecs.UuidCodec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public class MongoDBPartitionedStorageProvider
extends AbstractPartitionedStorageProvider
implements PartitionedStorageProvider {
    public static final String DEFAULT_DB_NAME = "carrot";
    private static final MongoDBPageRequestMapper pageRequestMapper = new MongoDBPageRequestMapper();
    private final String databaseName;
    private final MongoClient mongoClient;
    private final MongoDatabase carrotDatabase;
    private final Map<Integer, MongoCollection<Document>> taskCollectionMap = new HashMap<Integer, MongoCollection<Document>>();
    private final Map<Integer, MongoCollection<Document>> recurringTaskCollectionMap = new HashMap<Integer, MongoCollection<Document>>();
    private final MongoCollection<Document> metadataCollection;
    private final MongoCollection<Document> backgroundTaskServerCollection;
    private final LockProvider lockProvider;
    private final int totalNumOfPartitions;
    private final String collectionPrefix;
    private Partitioner partitioner;
    static final String ERR_MSG_INVALID_PARTITION = "invalid partition {%s}, DB operation will be ignored";
    private TaskDocumentMapper taskDocumentMapper;
    private BackgroundTaskServerStatusDocumentMapper backgroundTaskServerStatusDocumentMapper;
    private MetadataDocumentMapper metadataDocumentMapper;

    public MongoDBPartitionedStorageProvider(String connectionString) {
        this(connectionString, 1);
    }

    public MongoDBPartitionedStorageProvider(String connectionString, int totalNumOfPartitions) {
        this(MongoClients.create((MongoClientSettings)MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).codecRegistry(CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{CodecRegistries.fromCodecs((Codec[])new Codec[]{new UuidCodec(UuidRepresentation.STANDARD)}), MongoClientSettings.getDefaultCodecRegistry()})).build()), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, int totalNumOfPartitions) {
        this(mongoClient, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, String dbName, int totalNumOfPartitions) {
        this(mongoClient, dbName, null, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, String dbName, StorageProviderUtils.DatabaseOptions databaseOptions, int totalNumOfPartitions) {
        this(mongoClient, dbName, null, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, int totalNumOfPartitions) {
        this(mongoClient, dbName, collectionPrefix, StorageProviderUtils.DatabaseOptions.CREATE, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, int totalNumOfPartitions) {
        this(mongoClient, dbName, collectionPrefix, databaseOptions, RateLimiter.Builder.rateLimit().at1Request().per(RateLimiter.SECOND), totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, RateLimiter changeListenerNotificationRateLimit, int totalNumOfPartitions) {
        this(mongoClient, null, null, StorageProviderUtils.DatabaseOptions.CREATE, changeListenerNotificationRateLimit, totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit, int totalNumOfPartitions) {
        this(mongoClient, null, null, databaseOptions, changeListenerNotificationRateLimit, totalNumOfPartitions);
    }

    public MongoDBPartitionedStorageProvider(MongoClient mongoClient, String dbName, String collectionPrefix, StorageProviderUtils.DatabaseOptions databaseOptions, RateLimiter changeListenerNotificationRateLimit, int totalNumOfPartitions) {
        super(changeListenerNotificationRateLimit);
        this.validateMongoClient(mongoClient);
        this.databaseName = Optional.ofNullable(dbName).orElse(DEFAULT_DB_NAME);
        this.collectionPrefix = collectionPrefix;
        this.mongoClient = mongoClient;
        if (totalNumOfPartitions < 1) {
            throw new IllegalArgumentException("The totalNumOfPartitions can not be smaller than 1!");
        }
        this.totalNumOfPartitions = totalNumOfPartitions;
        this.partitioner = new RandomPartitioner(this.totalNumOfPartitions);
        this.carrotDatabase = mongoClient.getDatabase(this.databaseName);
        this.setUpStorageProvider(databaseOptions);
        for (int partition = 0; partition < this.totalNumOfPartitions; ++partition) {
            MongoCollection taskCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixerWithPartition(collectionPrefix, "tasks", partition), Document.class);
            this.taskCollectionMap.put(partition, (MongoCollection<Document>)taskCollection);
            MongoCollection recurringTaskCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixerWithPartition(collectionPrefix, "recurring_tasks", partition), Document.class);
            this.recurringTaskCollectionMap.put(partition, (MongoCollection<Document>)recurringTaskCollection);
        }
        this.backgroundTaskServerCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "background_task_servers"), Document.class);
        this.metadataCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "metadata"), Document.class);
        MongoCollection shedLockCollection = this.carrotDatabase.getCollection(StorageProviderUtils.elementPrefixer(collectionPrefix, "shed_lock"), Document.class);
        this.lockProvider = new MongoLockProvider((MongoCollection<Document>)shedLockCollection);
    }

    @Override
    public int getTotalNumOfPartitions() {
        return this.totalNumOfPartitions;
    }

    @Override
    public boolean lockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.lockProvider.lock("partition_" + partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean extendLockByPartition(Integer partition, int durationInSeconds, String lockedBy) {
        return this.lockProvider.extend("partition_" + partition, durationInSeconds, lockedBy);
    }

    @Override
    public boolean unlockByPartition(Integer partition) {
        return this.lockProvider.unlock("partition_" + partition);
    }

    @Override
    public void setTaskMapper(TaskMapper taskMapper) {
        this.taskDocumentMapper = new TaskDocumentMapper(taskMapper);
        this.backgroundTaskServerStatusDocumentMapper = new BackgroundTaskServerStatusDocumentMapper();
        this.metadataDocumentMapper = new MetadataDocumentMapper();
    }

    @Override
    public void setPartitioner(Partitioner partitioner) {
        this.partitioner = partitioner;
    }

    @Override
    public void setUpStorageProvider(StorageProviderUtils.DatabaseOptions databaseOptions) {
        if (StorageProviderUtils.DatabaseOptions.CREATE == databaseOptions) {
            this.runMigrations();
        } else {
            this.validateTables();
        }
    }

    @Override
    public void announceBackgroundTaskServer(BackgroundTaskServerStatus serverStatus) {
        InsertOneResult result = this.backgroundTaskServerCollection.insertOne((Object)this.backgroundTaskServerStatusDocumentMapper.toInsertDocument(serverStatus));
        if (!result.wasAcknowledged()) {
            throw new StorageException("Unable to announce BackgroundTaskServer");
        }
    }

    @Override
    public boolean signalBackgroundTaskServerAlive(BackgroundTaskServerStatus serverStatus) {
        UpdateResult updateResult = this.backgroundTaskServerCollection.updateOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)serverStatus.getId()), (Bson)this.backgroundTaskServerStatusDocumentMapper.toUpdateDocument(serverStatus));
        if (updateResult.getModifiedCount() < 1L) {
            throw new ServerTimedOutException(serverStatus, new StorageException("BackgroundTaskServer with id " + serverStatus.getId() + " was not found"));
        }
        Document document = (Document)this.backgroundTaskServerCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)serverStatus.getId())).projection(Projections.include((String[])new String[]{"running"})).first();
        return document != null && document.getBoolean((Object)"running") != false;
    }

    @Override
    public void signalBackgroundTaskServerStopped(BackgroundTaskServerStatus serverStatus) {
        this.backgroundTaskServerCollection.deleteOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)serverStatus.getId()));
    }

    @Override
    public List<BackgroundTaskServerStatus> getBackgroundTaskServers() {
        return (List)this.backgroundTaskServerCollection.find().sort(Sorts.ascending((String[])new String[]{"firstHeartbeat"})).map(this.backgroundTaskServerStatusDocumentMapper::toBackgroundTaskServerStatus).into(new ArrayList());
    }

    @Override
    public UUID getLongestRunningBackgroundTaskServerId() {
        return (UUID)this.backgroundTaskServerCollection.find().sort(Sorts.ascending((String[])new String[]{"firstHeartbeat"})).projection(Projections.include((String[])new String[]{MongoDBPartitionedStorageProvider.toMongoId("id")})).map(MongoUtils::getIdAsUUID).first();
    }

    @Override
    public int removeTimedOutBackgroundTaskServers(Instant heartbeatOlderThan) {
        DeleteResult deleteResult = this.backgroundTaskServerCollection.deleteMany(Filters.lt((String)"lastHeartbeat", (Object)heartbeatOlderThan));
        return (int)deleteResult.getDeletedCount();
    }

    @Override
    public void saveMetadata(CarrotMetadata metadata) {
        this.metadataCollection.updateOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)metadata.getId()), (Bson)this.metadataDocumentMapper.toUpdateDocument(metadata), new UpdateOptions().upsert(true));
        this.notifyMetadataChangeListeners();
    }

    @Override
    public List<CarrotMetadata> getMetadata(String name) {
        return (List)this.metadataCollection.find(Filters.eq((String)"name", (Object)name)).map(this.metadataDocumentMapper::toCarrotMetadata).into(new ArrayList());
    }

    @Override
    public CarrotMetadata getMetadata(String name, String owner) {
        Document document = (Document)this.metadataCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)CarrotMetadata.toId(name, owner))).first();
        return this.metadataDocumentMapper.toCarrotMetadata(document);
    }

    @Override
    public void deleteMetadata(String name) {
        DeleteResult deleteResult = this.metadataCollection.deleteMany(Filters.eq((String)"name", (Object)name));
        long deletedCount = deleteResult.getDeletedCount();
        this.notifyMetadataChangeListeners(deletedCount > 0L);
    }

    @Override
    public Task save(Task task) {
        Integer partition = null;
        if (task.getMetadata() != null) {
            partition = (Integer)task.getMetadata().get("partition_hint_key");
        }
        if (partition == null) {
            partition = this.partitioner.partition(task);
        }
        return this.saveByPartition(task, partition);
    }

    @Override
    public Task saveByPartition(Task task, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        try (TaskVersioner taskVersioner = new TaskVersioner(task);){
            if (taskVersioner.isNewTask()) {
                taskCollection.insertOne((Object)this.taskDocumentMapper.toInsertDocument(task));
            } else {
                UpdateOneModel<Document> updateModel = this.taskDocumentMapper.toUpdateOneModel(task);
                UpdateResult updateResult = taskCollection.updateOne(updateModel.getFilter(), updateModel.getUpdate());
                if (updateResult.getModifiedCount() < 1L) {
                    throw new ConcurrentTaskModificationException(task);
                }
            }
            taskVersioner.commitVersion();
        }
        catch (MongoWriteException e) {
            if (e.getError().getCode() == 11000) {
                throw new ConcurrentTaskModificationException(task);
            }
            throw new StorageException(e);
        }
        catch (MongoException e) {
            throw new StorageException(e);
        }
        this.notifyTaskStatsOnChangeListeners();
        return task;
    }

    @Override
    public int deletePermanentlyByPartition(UUID id, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        DeleteResult result = taskCollection.deleteOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)id));
        int deletedCount = (int)result.getDeletedCount();
        this.notifyTaskStatsOnChangeListenersIf(deletedCount > 0);
        return deletedCount;
    }

    @Override
    public Task getTaskById(UUID id) {
        for (int p = 0; p < this.totalNumOfPartitions; ++p) {
            MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(p);
            Document document = (Document)taskCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)id)).projection(Projections.include((String[])new String[]{"taskAsJson"})).first();
            if (document == null) continue;
            Task task = this.taskDocumentMapper.toTask(document);
            task.getMetadata().put("partition_hint_key", p);
            return task;
        }
        throw new TaskNotFoundException(id);
    }

    @Override
    public List<Task> save(List<Task> tasks) {
        Integer partition = this.partitioner.partition(tasks.get(0));
        return this.saveByPartition(tasks, partition);
    }

    @Override
    public List<Task> saveByPartition(List<Task> tasks, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        try (TaskListVersioner taskListVersioner = new TaskListVersioner(tasks);){
            if (taskListVersioner.areNewTasks()) {
                List tasksToInsert = tasks.stream().map(task -> this.taskDocumentMapper.toInsertDocument((Task)task)).collect(Collectors.toList());
                taskCollection.insertMany(tasksToInsert);
            } else {
                List tasksToUpdate = tasks.stream().map(task -> this.taskDocumentMapper.toUpdateOneModel((Task)task)).collect(Collectors.toList());
                BulkWriteResult bulkWriteResult = taskCollection.bulkWrite(tasksToUpdate);
                if (bulkWriteResult.getModifiedCount() != tasks.size()) {
                    HashMap mongoDbDocuments = new HashMap();
                    taskCollection.find(Filters.in((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Iterable)tasks.stream().map(Task::getId).collect(Collectors.toList()))).projection(Projections.include((String[])new String[]{"taskAsJson"})).map(this.taskDocumentMapper::toTask).forEach(task -> mongoDbDocuments.put(task.getId(), task));
                    List<Task> concurrentModificationTasks = tasks.stream().filter(task -> !task.getUpdatedAt().equals(((Task)mongoDbDocuments.get(task.getId())).getUpdatedAt())).collect(Collectors.toList());
                    taskListVersioner.rollbackVersions(concurrentModificationTasks);
                    throw new ConcurrentTaskModificationException(concurrentModificationTasks);
                }
            }
            taskListVersioner.commitVersions();
        }
        catch (MongoException e) {
            throw new StorageException(e);
        }
        this.notifyTaskStatsOnChangeListenersIf(!tasks.isEmpty());
        return tasks;
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, Instant updatedBefore, PageRequest pageRequest, Integer partition) {
        return this.findTasks(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)state.name()), Filters.lt((String)"updatedAt", (Object)this.toMicroSeconds(updatedBefore))}), pageRequest, partition);
    }

    @Override
    public List<Task> getScheduledTasksByPartition(Instant scheduledBefore, PageRequest pageRequest, Integer partition) {
        return this.findTasks(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)StateName.SCHEDULED.name()), Filters.lt((String)"scheduledAt", (Object)this.toMicroSeconds(scheduledBefore))}), pageRequest, partition);
    }

    @Override
    public List<Task> getTasksByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.findTasks(Filters.eq((String)"state", (Object)state.name()), pageRequest, partition);
    }

    @Override
    public Page<Task> getTaskPageByPartition(StateName state, PageRequest pageRequest, Integer partition) {
        return this.getTaskPageByPartition(Filters.eq((String)"state", (Object)state.name()), pageRequest, partition);
    }

    @Override
    public int deleteTasksPermanentlyByPartition(StateName state, Instant updatedBefore, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        DeleteResult deleteResult = taskCollection.deleteMany(Filters.and((Bson[])new Bson[]{Filters.eq((String)"state", (Object)state.name()), Filters.lt((String)"createdAt", (Object)this.toMicroSeconds(updatedBefore))}));
        long deletedCount = deleteResult.getDeletedCount();
        this.notifyTaskStatsOnChangeListenersIf(deletedCount > 0L);
        return (int)deletedCount;
    }

    @Override
    public Set<String> getDistinctTaskSignatures(StateName ... states) {
        HashSet<String> resultSet = new HashSet<String>();
        for (int p = 0; p < this.totalNumOfPartitions; ++p) {
            Set<String> sigSet = this.getDistinctTaskSignaturesByPartition(p, states);
            resultSet.addAll(sigSet);
        }
        return resultSet;
    }

    private Set<String> getDistinctTaskSignaturesByPartition(Integer partition, StateName ... states) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        return (Set)taskCollection.distinct("taskSignature", Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), String.class).into(new HashSet());
    }

    @Override
    public boolean existsByPartition(TaskDetails taskDetails, Integer partition, StateName ... states) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        return taskCollection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), Filters.eq((String)"taskSignature", (Object)TaskUtils.getTaskSignature(taskDetails))})) > 0L;
    }

    @Override
    public boolean recurringTaskExistsByPartition(String recurringTaskId, Integer partition, StateName ... states) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        return taskCollection.countDocuments(Filters.and((Bson[])new Bson[]{Filters.in((String)"state", (Iterable)Arrays.stream(states).map(Enum::name).collect(Collectors.toSet())), Filters.eq((String)"recurringTaskId", (Object)recurringTaskId)})) > 0L;
    }

    @Override
    public RecurringTask saveRecurringTask(RecurringTask recurringTask) {
        Integer partition = this.partitioner.partition(recurringTask);
        return this.saveRecurringTaskByPartition(recurringTask, partition);
    }

    public RecurringTask saveRecurringTaskByPartition(RecurringTask recurringTask, Integer partition) {
        MongoCollection<Document> recurringTaskCollection = this.validateThenGetRecurringTaskPartition(partition);
        recurringTaskCollection.replaceOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)recurringTask.getId()), (Object)this.taskDocumentMapper.toInsertDocument(recurringTask), new ReplaceOptions().upsert(true));
        return recurringTask;
    }

    @Override
    public List<RecurringTask> getRecurringTasksByPartition(Integer partition) {
        MongoCollection<Document> recurringTaskCollection = this.validateThenGetRecurringTaskPartition(partition);
        return (List)recurringTaskCollection.find().map(this.taskDocumentMapper::toRecurringTask).into(new ArrayList());
    }

    @Override
    public List<RecurringTask> getRecurringTasks() {
        ArrayList<RecurringTask> results = new ArrayList<RecurringTask>();
        for (int p = 0; p < this.totalNumOfPartitions; ++p) {
            List<RecurringTask> recurringTasks = this.getRecurringTasksByPartition(p);
            results.addAll(recurringTasks);
        }
        return results;
    }

    @Override
    public long countRecurringTasksByPartition(Integer partition) {
        MongoCollection<Document> recurringTaskCollection = this.validateThenGetRecurringTaskPartition(partition);
        return recurringTaskCollection.countDocuments();
    }

    @Override
    public int deleteRecurringTask(String id) {
        for (int p = 0; p < this.totalNumOfPartitions; ++p) {
            int count = this.deleteRecurringTaskByPartition(id, p);
            if (count <= 0) continue;
            return count;
        }
        return 0;
    }

    private int deleteRecurringTaskByPartition(String id, Integer partition) {
        MongoCollection<Document> recurringTaskCollection = this.validateThenGetRecurringTaskPartition(partition);
        DeleteResult deleteResult = recurringTaskCollection.deleteOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)id));
        return (int)deleteResult.getDeletedCount();
    }

    @Override
    public TaskStatsData getTaskStatsData() {
        TaskStatsData data = new TaskStatsData();
        TaskStats taskStats0 = this.calculateTaskStats(0);
        data.getTaskStatsList().add(taskStats0);
        Instant instant = taskStats0.getTimeStamp();
        Long scheduledCount = taskStats0.getScheduled();
        Long enqueuedCount = taskStats0.getEnqueued();
        Long processingCount = taskStats0.getProcessing();
        Long succeededCount = taskStats0.getSucceeded();
        Long failedCount = taskStats0.getFailed();
        Long deletedCount = taskStats0.getDeleted();
        Long allTimeSucceededCount = taskStats0.getAllTimeSucceeded();
        Long total = taskStats0.getTotal();
        int recurringTaskCount = taskStats0.getRecurringTasks();
        int backgroundTaskServerCount = taskStats0.getBackgroundTaskServers();
        for (int p = 1; p < this.totalNumOfPartitions; ++p) {
            TaskStats taskStats = this.calculateTaskStats(p);
            data.getTaskStatsList().add(taskStats);
            scheduledCount = scheduledCount + taskStats.getScheduled();
            enqueuedCount = enqueuedCount + taskStats.getEnqueued();
            processingCount = processingCount + taskStats.getProcessing();
            succeededCount = succeededCount + taskStats.getSucceeded();
            failedCount = failedCount + taskStats.getFailed();
            deletedCount = deletedCount + taskStats.getDeleted();
            total = total + taskStats.getTotal();
            recurringTaskCount += taskStats.getRecurringTasks();
        }
        TaskStats overallTaskStats = new TaskStats(instant, total, scheduledCount, enqueuedCount, processingCount, failedCount, succeededCount, allTimeSucceededCount, deletedCount, recurringTaskCount, backgroundTaskServerCount);
        data.setOverallTaskStats(overallTaskStats);
        return data;
    }

    private TaskStats calculateTaskStats(Integer partition) {
        Instant instant = Instant.now();
        Document succeededTaskStats = (Document)this.metadataCollection.find(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)"succeeded-tasks-counter-cluster")).first();
        long allTimeSucceededCount = succeededTaskStats != null ? ((Number)succeededTaskStats.get((Object)"value")).longValue() : 0L;
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        List aggregates = (List)taskCollection.aggregate(Arrays.asList(Aggregates.match((Bson)Filters.ne((String)"state", null)), Aggregates.group((Object)"$state", (BsonField[])new BsonField[]{Accumulators.sum((String)"state", (Object)1)}), Aggregates.limit((int)10))).into(new ArrayList());
        Long scheduledCount = this.getCount(StateName.SCHEDULED, aggregates);
        Long enqueuedCount = this.getCount(StateName.ENQUEUED, aggregates);
        Long processingCount = this.getCount(StateName.PROCESSING, aggregates);
        Long succeededCount = this.getCount(StateName.SUCCEEDED, aggregates);
        Long failedCount = this.getCount(StateName.FAILED, aggregates);
        Long deletedCount = this.getCount(StateName.DELETED, aggregates);
        long total = scheduledCount + enqueuedCount + processingCount + succeededCount + failedCount;
        MongoCollection<Document> recurringTaskCollection = this.validateThenGetRecurringTaskPartition(partition);
        int recurringTaskCount = (int)recurringTaskCollection.countDocuments();
        int backgroundTaskServerCount = (int)this.backgroundTaskServerCollection.countDocuments();
        return new TaskStats(instant, total, scheduledCount, enqueuedCount, processingCount, failedCount, succeededCount, allTimeSucceededCount, deletedCount, recurringTaskCount, backgroundTaskServerCount);
    }

    @Override
    public void publishTotalAmountOfSucceededTasks(int amount) {
        this.metadataCollection.updateOne(Filters.eq((String)MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)"succeeded-tasks-counter-cluster"), Updates.inc((String)"value", (Number)amount), new UpdateOptions().upsert(true));
    }

    private void validateMongoClient(MongoClient mongoClient) {
        Optional<Method> codecRegistryGetter = ReflectionUtils.findMethod(mongoClient, "getCodecRegistry", new Class[0]);
        if (codecRegistryGetter.isPresent()) {
            try {
                CodecRegistry codecRegistry = (CodecRegistry)codecRegistryGetter.get().invoke((Object)mongoClient, new Object[0]);
                UuidCodec uuidCodec = (UuidCodec)codecRegistry.get(UUID.class);
                if (UuidRepresentation.UNSPECIFIED == uuidCodec.getUuidRepresentation()) {
                    throw new StorageException("\nSince release 4.0.0 of the MongoDB Java Driver, the default BSON representation of java.util.UUID values has changed from JAVA_LEGACY to UNSPECIFIED.\nApplications that store or retrieve UUID values must explicitly specify which representation to use, via the uuidRepresentation property of MongoClientSettings.\nThe good news is that Carrot works both with the STANDARD as the JAVA_LEGACY uuidRepresentation. Please choose the one most appropriate for your application.");
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw CarrotException.shouldNotHappenException(e);
            }
        }
    }

    private void runMigrations() {
        new MongoDBCreator(this.mongoClient, this.databaseName, this.collectionPrefix, this.totalNumOfPartitions).runMigrations();
    }

    private void validateTables() {
        new MongoDBCreator(this.mongoClient, this.databaseName, this.collectionPrefix, this.totalNumOfPartitions).validateCollections();
    }

    private Page<Task> getTaskPageByPartition(Bson query, PageRequest pageRequest, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        long count = taskCollection.countDocuments(query);
        if (count > 0L) {
            List<Task> tasks = this.findTasks(query, pageRequest, partition);
            return new Page<Task>(count, tasks, pageRequest);
        }
        return new Page<Task>(0L, new ArrayList(), pageRequest);
    }

    private List<Task> findTasks(Bson query, PageRequest pageRequest, Integer partition) {
        MongoCollection<Document> taskCollection = this.validateThenGetTaskPartition(partition);
        return (List)taskCollection.find(query).sort(pageRequestMapper.map(pageRequest)).skip((int)pageRequest.getOffset()).limit(pageRequest.getLimit()).projection(Projections.include((String[])new String[]{"taskAsJson"})).map(this.taskDocumentMapper::toTask).into(new ArrayList());
    }

    private MongoCollection<Document> validateThenGetTaskPartition(Integer partition) {
        MongoCollection<Document> taskCollection = this.taskCollectionMap.get(partition);
        if (taskCollection == null) {
            throw new IllegalArgumentException(String.format(ERR_MSG_INVALID_PARTITION, partition));
        }
        return taskCollection;
    }

    private MongoCollection<Document> validateThenGetRecurringTaskPartition(Integer partition) {
        MongoCollection<Document> recurringTaskCollection = this.recurringTaskCollectionMap.get(partition);
        if (recurringTaskCollection == null) {
            throw new IllegalArgumentException(String.format(ERR_MSG_INVALID_PARTITION, partition));
        }
        return recurringTaskCollection;
    }

    private long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }

    private Long getCount(StateName stateName, List<Document> aggregates) {
        Predicate<Document> statePredicate = document -> stateName.name().equals(document.get((Object)MongoDBPartitionedStorageProvider.toMongoId("id")));
        BiFunction<Optional, Integer, Integer> count = (document, defaultValue) -> document.map(doc -> doc.getInteger((Object)"state")).orElse((Integer)defaultValue);
        long aggregateCount = count.apply(aggregates.stream().filter(statePredicate).findFirst(), 0).intValue();
        return aggregateCount;
    }

    public static String toMongoId(String id) {
        return "_" + id;
    }
}

