/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo.mapper;

import cn.boboweike.carrot.storage.BackgroundTaskServerStatus;
import cn.boboweike.carrot.storage.nosql.mongo.MongoUtils;
import java.time.Duration;
import java.util.Date;
import org.bson.Document;

public class BackgroundTaskServerStatusDocumentMapper {
    public Document toInsertDocument(BackgroundTaskServerStatus serverStatus) {
        Document document = new Document();
        document.put("_id", (Object)serverStatus.getId());
        document.put("workerPoolSize", (Object)serverStatus.getWorkerPoolSize());
        document.put("pollIntervalInSeconds", (Object)serverStatus.getPollIntervalInSeconds());
        document.put("deleteSucceededTasksAfter", (Object)serverStatus.getDeleteSucceededTasksAfter().toString());
        document.put("permanentlyDeleteDeletedTasksAfter", (Object)serverStatus.getPermanentlyDeleteDeletedTasksAfter().toString());
        document.put("firstHeartbeat", (Object)serverStatus.getFirstHeartbeat());
        document.put("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
        document.put("running", (Object)serverStatus.isRunning());
        document.put("systemTotalMemory", (Object)serverStatus.getSystemTotalMemory());
        document.put("systemFreeMemory", (Object)serverStatus.getSystemFreeMemory());
        document.put("systemCpuLoad", (Object)serverStatus.getSystemCpuLoad());
        document.put("processMaxMemory", (Object)serverStatus.getProcessMaxMemory());
        document.put("processFreeMemory", (Object)serverStatus.getProcessFreeMemory());
        document.put("processAllocatedMemory", (Object)serverStatus.getProcessAllocatedMemory());
        document.put("processCpuLoad", (Object)serverStatus.getProcessCpuLoad());
        document.put("partition", (Object)serverStatus.getPartition());
        return document;
    }

    public Document toUpdateDocument(BackgroundTaskServerStatus serverStatus) {
        Document document = new Document();
        document.put("lastHeartbeat", (Object)serverStatus.getLastHeartbeat());
        document.put("systemFreeMemory", (Object)serverStatus.getSystemFreeMemory());
        document.put("systemCpuLoad", (Object)serverStatus.getSystemCpuLoad());
        document.put("processFreeMemory", (Object)serverStatus.getProcessFreeMemory());
        document.put("processAllocatedMemory", (Object)serverStatus.getProcessAllocatedMemory());
        document.put("processCpuLoad", (Object)serverStatus.getProcessCpuLoad());
        document.put("partition", (Object)serverStatus.getPartition());
        return new Document("$set", (Object)document);
    }

    public BackgroundTaskServerStatus toBackgroundTaskServerStatus(Document document) {
        return new BackgroundTaskServerStatus(MongoUtils.getIdAsUUID(document), document.getInteger((Object)"workerPoolSize"), document.getInteger((Object)"pollIntervalInSeconds"), Duration.parse(document.getString((Object)"deleteSucceededTasksAfter")), Duration.parse(document.getString((Object)"permanentlyDeleteDeletedTasksAfter")), ((Date)document.get((Object)"firstHeartbeat", Date.class)).toInstant(), ((Date)document.get((Object)"lastHeartbeat", Date.class)).toInstant(), document.getBoolean((Object)"running"), document.getLong((Object)"systemTotalMemory"), document.getLong((Object)"systemFreeMemory"), document.getDouble((Object)"systemCpuLoad"), document.getLong((Object)"processMaxMemory"), document.getLong((Object)"processFreeMemory"), document.getLong((Object)"processAllocatedMemory"), document.getDouble((Object)"processCpuLoad"), document.getInteger((Object)"partition"));
    }
}

