/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo.mapper;

import cn.boboweike.carrot.storage.nosql.mongo.MongoDBPartitionedStorageProvider;
import cn.boboweike.carrot.tasks.RecurringTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.mappers.TaskMapper;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.StateName;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.UpdateOneModel;
import com.mongodb.client.model.UpdateOptions;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.UUID;
import org.bson.Document;
import org.bson.conversions.Bson;

public class TaskDocumentMapper {
    private final TaskMapper taskMapper;

    public TaskDocumentMapper(TaskMapper taskMapper) {
        this.taskMapper = taskMapper;
    }

    public Document toInsertDocument(Task task) {
        Document document = new Document();
        document.put(MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)task.getId());
        document.put("version", (Object)task.getVersion());
        document.put("taskAsJson", (Object)this.taskMapper.serializeTask(task));
        document.put("taskSignature", (Object)task.getTaskSignature());
        document.put("state", (Object)task.getState().name());
        document.put("createdAt", (Object)this.toMicroSeconds(task.getCreatedAt()));
        document.put("updatedAt", (Object)this.toMicroSeconds(task.getUpdatedAt()));
        if (task.hasState(StateName.SCHEDULED)) {
            document.put("scheduledAt", (Object)this.toMicroSeconds(((ScheduledState)task.getTaskState()).getScheduledAt()));
        }
        task.getRecurringTaskId().ifPresent(recurringTaskId -> document.put("recurringTaskId", recurringTaskId));
        return document;
    }

    public Document toUpdateDocument(Task task) {
        Document document = new Document();
        document.put("version", (Object)task.getVersion());
        document.put("taskAsJson", (Object)this.taskMapper.serializeTask(task));
        document.put("state", (Object)task.getState().name());
        document.put("updatedAt", (Object)this.toMicroSeconds(task.getUpdatedAt()));
        if (task.hasState(StateName.SCHEDULED)) {
            document.put("scheduledAt", (Object)this.toMicroSeconds(((ScheduledState)task.getTaskState()).getScheduledAt()));
        }
        task.getRecurringTaskId().ifPresent(recurringTaskId -> document.put("recurringTaskId", recurringTaskId));
        return new Document("$set", (Object)document);
    }

    public UpdateOneModel<Document> toUpdateOneModel(Task task) {
        Document filterDocument = new Document();
        filterDocument.append(MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)task.getId());
        filterDocument.append("version", (Object)(task.getVersion() - 1));
        Document updateDocument = this.toUpdateDocument(task);
        UpdateOptions updateOptions = new UpdateOptions();
        updateOptions.upsert(false);
        return new UpdateOneModel((Bson)filterDocument, (Bson)updateDocument, updateOptions);
    }

    public Task toTask(Document document) {
        return this.taskMapper.deserializeTask(document.get((Object)"taskAsJson").toString());
    }

    public Document toInsertDocument(RecurringTask recurringTask) {
        Document document = new Document();
        document.put(MongoDBPartitionedStorageProvider.toMongoId("id"), (Object)recurringTask.getId());
        document.put("version", (Object)recurringTask.getVersion());
        document.put("taskAsJson", (Object)this.taskMapper.serializeRecurringTask(recurringTask));
        return document;
    }

    public Bson byId(List<UUID> ids) {
        return Filters.in((String)MongoDBPartitionedStorageProvider.toMongoId("id"), ids);
    }

    public RecurringTask toRecurringTask(Document document) {
        return this.taskMapper.deserializeRecurringTask(document.get((Object)"taskAsJson").toString());
    }

    private long toMicroSeconds(Instant instant) {
        return ChronoUnit.MICROS.between(Instant.EPOCH, instant);
    }
}

