/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.MongoMigration;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M001_CreateTaskCollection
extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M001_CreateTaskCollection.class);

    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        String collectionName = StorageProviderUtils.elementPrefixerWithPartition(collectionPrefix, "tasks", partition);
        if (this.collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", (Object)collectionName);
            return;
        }
        LOGGER.info("Running migration {}", (Object)collectionName);
        if (this.createCollection(carrotDatabase, collectionName)) {
            MongoCollection taskCollection = carrotDatabase.getCollection(collectionName, Document.class);
            taskCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"scheduledAt"})}));
            taskCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"updatedAt"})}));
            taskCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.descending((String[])new String[]{"updatedAt"})}));
            taskCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"createdAt"})}));
            taskCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"state"}), Indexes.ascending((String[])new String[]{"taskSignature"})}));
        }
    }

    @Override
    public boolean supportPartition() {
        return true;
    }
}

