/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.storage.nosql.mongo.migrations;

import cn.boboweike.carrot.storage.StorageProviderUtils;
import cn.boboweike.carrot.storage.nosql.mongo.migrations.MongoMigration;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Indexes;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class M003_CreateMetadataCollection
extends MongoMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(M003_CreateMetadataCollection.class);

    @Override
    public void runMigration(MongoDatabase carrotDatabase, String collectionPrefix, Integer partition) {
        String collectionName = StorageProviderUtils.elementPrefixer(collectionPrefix, "metadata");
        if (this.collectionExists(carrotDatabase, collectionName)) {
            LOGGER.info("Skipping migration {} as it is already done", (Object)collectionName);
            return;
        }
        LOGGER.info("Running migration {}", (Object)collectionName);
        if (this.createCollection(carrotDatabase, collectionName)) {
            this.createMetadataCollection(carrotDatabase, collectionName);
        }
    }

    private void createMetadataCollection(MongoDatabase carrotDatabase, String processedMetadataCollectionName) {
        MongoCollection metadataCollection = carrotDatabase.getCollection(processedMetadataCollectionName, Document.class);
        metadataCollection.createIndex(Indexes.compoundIndex((Bson[])new Bson[]{Indexes.ascending((String[])new String[]{"name"}), Indexes.ascending((String[])new String[]{"owner"})}));
        metadataCollection.insertOne((Object)this.initialAllTimeSucceededTaskCounterDocument());
    }

    private Document initialAllTimeSucceededTaskCounterDocument() {
        Document document = new Document();
        document.put("id", (Object)"succeeded-tasks-counter-cluster");
        document.put("name", (Object)"succeeded-tasks-counter");
        document.put("owner", (Object)"cluster");
        document.put("value", (Object)0L);
        return document;
    }
}

