/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.resilience.Lock;
import cn.boboweike.carrot.utils.resilience.Lockable;

public abstract class AbstractTask
implements Lockable {
    private final transient Lock locker = new Lock();
    private volatile int version;
    private String taskSignature;
    private String taskName;
    private TaskDetails taskDetails;

    protected AbstractTask() {
    }

    protected AbstractTask(TaskDetails taskDetails) {
        this(taskDetails, 0);
    }

    protected AbstractTask(TaskDetails taskDetails, int version) {
        this();
        this.taskDetails = taskDetails;
        this.version = version;
        this.taskSignature = TaskUtils.getTaskSignature(taskDetails);
    }

    public abstract Object getId();

    public int getVersion() {
        return this.version;
    }

    synchronized int increaseVersion() {
        return ++this.version;
    }

    void setVersion(int version) {
        this.version = version;
    }

    public String getTaskSignature() {
        return this.taskSignature;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public TaskDetails getTaskDetails() {
        return this.taskDetails;
    }

    @Override
    public Lock lock() {
        return this.locker.lock();
    }
}

