/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.scheduling.Schedule;
import cn.boboweike.carrot.scheduling.ScheduleExpressionType;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.states.EnqueuedState;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Optional;

public class RecurringTask
extends AbstractTask {
    private String id;
    private String scheduleExpression;
    private String zoneId;
    private Instant createdAt;

    private RecurringTask() {
    }

    public RecurringTask(String id, TaskDetails taskDetails, String scheduleExpression, String zoneId) {
        this(id, taskDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId));
    }

    public RecurringTask(String id, TaskDetails taskDetails, Schedule schedule, ZoneId zoneId) {
        this(id, taskDetails, schedule, zoneId, Instant.now(Clock.system(zoneId)));
    }

    public RecurringTask(String id, TaskDetails taskDetails, String scheduleExpression, String zoneId, String createdAt) {
        this(id, taskDetails, ScheduleExpressionType.getSchedule(scheduleExpression), ZoneId.of(zoneId), Instant.parse(createdAt));
    }

    public RecurringTask(String id, TaskDetails taskDetails, Schedule schedule, ZoneId zoneId, Instant createdAt) {
        super(taskDetails);
        schedule.validateSchedule();
        this.id = this.validateAndSetId(id);
        this.zoneId = zoneId.getId();
        this.scheduleExpression = schedule.toString();
        this.createdAt = createdAt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getScheduleExpression() {
        return this.scheduleExpression;
    }

    public Task toScheduledTask() {
        Instant nextRun = this.getNextRun();
        Task task = new Task(this.getTaskDetails(), new ScheduledState(nextRun, this));
        task.setTaskName(this.getTaskName());
        task.setRecurringTaskId(this.getId());
        return task;
    }

    public Task toEnqueuedTask() {
        Task task = new Task(this.getTaskDetails(), new EnqueuedState());
        task.setTaskName(this.getTaskName());
        task.setRecurringTaskId(this.getId());
        return task;
    }

    public String getZoneId() {
        return this.zoneId;
    }

    public Instant getCreatedAt() {
        return this.createdAt;
    }

    public Instant getNextRun() {
        return ScheduleExpressionType.getSchedule(this.scheduleExpression).next(this.createdAt, ZoneId.of(this.zoneId));
    }

    private String validateAndSetId(String input) {
        String result = Optional.ofNullable(input).orElse(this.getTaskSignature().replace("$", "_"));
        if (!result.matches("[\\dA-Za-z-_(),.]+")) {
            throw new IllegalArgumentException("The id of a recurring task can only contain letters and numbers.");
        }
        return result;
    }

    public String toString() {
        return "RecurringTask{id=" + this.id + ", version='" + this.getVersion() + "', identity='" + System.identityHashCode(this) + "', taskSignature='" + this.getTaskSignature() + "', taskName='" + this.getTaskName() + "'}";
    }
}

