/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.server.BackgroundTaskServer;
import cn.boboweike.carrot.storage.ConcurrentTaskModificationException;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.states.AllowedTaskStateStateChanges;
import cn.boboweike.carrot.tasks.states.DeletedState;
import cn.boboweike.carrot.tasks.states.EnqueuedState;
import cn.boboweike.carrot.tasks.states.FailedState;
import cn.boboweike.carrot.tasks.states.IllegalTaskStateChangeException;
import cn.boboweike.carrot.tasks.states.ProcessingState;
import cn.boboweike.carrot.tasks.states.ScheduledState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.SucceededState;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Stream;

public class Task
extends AbstractTask {
    private final UUID id;
    private final ArrayList<TaskState> taskHistory;
    private final ConcurrentMap<String, Object> metadata;
    private String recurringTaskId;

    private Task() {
        this.id = null;
        this.taskHistory = new ArrayList();
        this.metadata = new ConcurrentHashMap<String, Object>();
    }

    public Task(TaskDetails taskDetails) {
        this(taskDetails, new EnqueuedState());
    }

    public Task(UUID id, TaskDetails taskDetails) {
        this(id, taskDetails, new EnqueuedState());
    }

    public Task(TaskDetails taskDetails, TaskState taskState) {
        this(null, 0, taskDetails, Collections.singletonList(taskState), new ConcurrentHashMap<String, Object>());
    }

    public Task(UUID id, TaskDetails taskDetails, TaskState taskState) {
        this(id, 0, taskDetails, Collections.singletonList(taskState), new ConcurrentHashMap<String, Object>());
    }

    public Task(UUID id, int version, TaskDetails taskDetails, List<TaskState> taskHistory, ConcurrentMap<String, Object> metadata) {
        super(taskDetails, version);
        if (taskHistory.isEmpty()) {
            throw new IllegalStateException("A task should have at least one initial state");
        }
        this.id = id != null ? id : UUID.randomUUID();
        this.taskHistory = new ArrayList<TaskState>(taskHistory);
        this.metadata = metadata;
    }

    @Override
    public UUID getId() {
        return this.id;
    }

    public void setRecurringTaskId(String recurringTaskId) {
        this.recurringTaskId = recurringTaskId;
    }

    public Optional<String> getRecurringTaskId() {
        return Optional.ofNullable(this.recurringTaskId);
    }

    public List<TaskState> getTaskStates() {
        return Collections.unmodifiableList(this.taskHistory);
    }

    public <T extends TaskState> Stream<T> getTaskStatesOfType(Class<T> clazz) {
        return StreamUtils.ofType(this.getTaskStates(), clazz);
    }

    public <T extends TaskState> Optional<T> getLastTaskStateOfType(Class<T> clazz) {
        return this.getTaskStatesOfType(clazz).reduce((first, second) -> second);
    }

    public <T extends TaskState> T getTaskState() {
        return (T)((TaskState)ReflectionUtils.cast(this.getTaskState(-1)));
    }

    public TaskState getTaskState(int element) {
        if (element >= 0) {
            return this.taskHistory.get(element);
        }
        if (Math.abs(element) > this.taskHistory.size()) {
            return null;
        }
        return this.taskHistory.get(this.taskHistory.size() + element);
    }

    public StateName getState() {
        return this.getTaskState().getName();
    }

    public boolean hasState(StateName state) {
        return this.getState().equals((Object)state);
    }

    public void enqueue() {
        this.addTaskState(new EnqueuedState());
    }

    public void scheduleAt(Instant instant, String reason) {
        this.addTaskState(new ScheduledState(instant, reason));
    }

    public void startProcessingOn(BackgroundTaskServer backgroundTaskServer) {
        if (this.getState() == StateName.PROCESSING) {
            throw new ConcurrentTaskModificationException(this);
        }
        this.addTaskState(new ProcessingState(backgroundTaskServer.getId()));
    }

    public void updateProcessing() {
        ProcessingState taskState = (ProcessingState)this.getTaskState();
        taskState.setUpdatedAt(Instant.now());
    }

    public void succeeded() {
        Optional<EnqueuedState> lastEnqueuedState = this.getLastTaskStateOfType(EnqueuedState.class);
        if (!lastEnqueuedState.isPresent()) {
            throw new IllegalStateException("Task cannot succeed if it was not enqueued before.");
        }
        this.clearMetadata();
        Duration latencyDuration = Duration.between(lastEnqueuedState.get().getEnqueuedAt(), this.getTaskState().getCreatedAt());
        Duration processDuration = Duration.between(this.getTaskState().getCreatedAt(), Instant.now());
        this.addTaskState(new SucceededState(latencyDuration, processDuration));
    }

    public void failed(String message, Exception exception) {
        this.addTaskState(new FailedState(message, exception));
    }

    public void delete(String reason) {
        this.clearMetadata();
        this.addTaskState(new DeletedState(reason));
    }

    public Instant getCreatedAt() {
        return this.getTaskState(0).getCreatedAt();
    }

    public Instant getUpdatedAt() {
        return this.getTaskState().getUpdatedAt();
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public String toString() {
        return "Task{id=" + this.id + ", version='" + this.getVersion() + "', identity='" + System.identityHashCode(this) + "', taskSignature='" + this.getTaskSignature() + "', taskName='" + this.getTaskName() + "', taskState='" + this.getState() + "', updatedAt='" + this.getUpdatedAt() + "'}";
    }

    private void addTaskState(TaskState taskState) {
        if (AllowedTaskStateStateChanges.isIllegalStateChange(this.getState(), taskState.getName())) {
            throw new IllegalTaskStateChangeException(this.getState(), taskState.getName());
        }
        this.taskHistory.add(taskState);
    }

    private void clearMetadata() {
        this.metadata.entrySet().removeIf(entry -> !((String)entry.getKey()).equals("partition_hint_key") && !((String)entry.getKey()).matches("(\\bcarrotDashboardLog\\b|\\bcarrotDashboardProgressBar\\b)-(\\d)"));
    }
}

