/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.lambdas.TaskRequest;
import cn.boboweike.carrot.utils.CollectionUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TaskDetails {
    private final String className;
    private final String staticFieldName;
    private final String methodName;
    private final ArrayList<TaskParameter> taskParameters;
    private Boolean cacheable;

    private TaskDetails() {
        this(null, null, null, null);
    }

    public TaskDetails(TaskRequest taskRequest) {
        this(taskRequest.getTaskRequestHandler().getName(), null, "run", Arrays.asList(new TaskParameter(taskRequest)));
        this.cacheable = true;
    }

    public TaskDetails(String className, String staticFieldName, String methodName, List<TaskParameter> taskParameters) {
        this.className = className;
        this.staticFieldName = staticFieldName;
        this.methodName = methodName;
        this.taskParameters = CollectionUtils.asArrayList(taskParameters);
        this.cacheable = false;
    }

    public String getClassName() {
        return this.className;
    }

    public String getStaticFieldName() {
        return this.staticFieldName;
    }

    public boolean hasStaticFieldName() {
        return this.staticFieldName != null;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public List<TaskParameter> getTaskParameters() {
        return Collections.unmodifiableList(this.taskParameters);
    }

    public Class[] getTaskParameterTypes() {
        return (Class[])this.taskParameters.stream().map(TaskParameter::getClassName).map(ReflectionUtils::toClass).toArray(Class[]::new);
    }

    public Object[] getTaskParameterValues() {
        return this.taskParameters.stream().map(TaskParameter::getObject).toArray();
    }

    public Boolean getCacheable() {
        return this.cacheable;
    }

    public void setCacheable(boolean cacheable) {
        this.cacheable = cacheable;
    }
}

