/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.TaskVersioner;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class TaskListVersioner
implements AutoCloseable {
    private final List<TaskVersioner> taskVersioners;

    public TaskListVersioner(List<Task> tasks) {
        this.taskVersioners = tasks.stream().map(TaskVersioner::new).collect(Collectors.toList());
    }

    public boolean areNewTasks() {
        this.validateTasks();
        return this.taskVersioners.get(0).isNewTask();
    }

    public void validateTasks() {
        if (this.taskVersioners.get(0).isNewTask() ? !this.taskVersioners.stream().allMatch(TaskVersioner::isNewTask) : this.taskVersioners.stream().anyMatch(TaskVersioner::isNewTask)) {
            throw new IllegalArgumentException("All tasks must be either new (with id == null) or existing (with id != null)");
        }
    }

    public void commitVersions() {
        this.taskVersioners.forEach(TaskVersioner::commitVersion);
    }

    public void rollbackVersions(List<Task> tasksThatFailed) {
        Set taskIdsThatFailed = tasksThatFailed.stream().map(Task::getId).collect(Collectors.toSet());
        this.taskVersioners.stream().filter(taskVersioner -> !taskIdsThatFailed.contains(taskVersioner.getTask().getId())).forEach(TaskVersioner::commitVersion);
    }

    @Override
    public void close() {
        this.taskVersioners.forEach(TaskVersioner::close);
    }
}

