/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.server.runner.RunnerTaskContext;
import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskDashboardLogger;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class CarrotDashboardLogger
implements Logger {
    private static final ThreadLocal<TaskDashboardLogger> taskDashboardLoggerThreadLocal = new ThreadLocal();
    private final Logger logger;
    private final TaskDashboardLogger.Level threshold;

    public CarrotDashboardLogger(Logger logger) {
        this(logger, TaskDashboardLogger.Level.INFO);
    }

    public CarrotDashboardLogger(Logger logger, TaskDashboardLogger.Level threshold) {
        this.logger = logger;
        this.threshold = threshold;
    }

    public static void setTask(Task task) {
        taskDashboardLoggerThreadLocal.set(new RunnerTaskContext(task).logger());
    }

    public static void clearTask() {
        taskDashboardLoggerThreadLocal.remove();
    }

    public String getName() {
        return this.logger.getName();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public void trace(String msg) {
        this.logger.trace(msg);
    }

    public void trace(String format, Object arg) {
        this.logger.trace(format, arg);
    }

    public void trace(String format, Object arg1, Object arg2) {
        this.logger.trace(format, arg1, arg2);
    }

    public void trace(String format, Object ... arguments) {
        this.logger.trace(format, arguments);
    }

    public void trace(String msg, Throwable t) {
        this.logger.trace(msg, t);
    }

    public boolean isTraceEnabled(Marker marker) {
        return this.logger.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        this.logger.trace(marker, msg);
    }

    public void trace(Marker marker, String format, Object arg) {
        this.logger.trace(marker, format, arg);
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.trace(marker, format, arg1, arg2);
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        this.logger.trace(marker, format, argArray);
    }

    public void trace(Marker marker, String msg, Throwable t) {
        this.logger.trace(marker, msg, t);
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void debug(String format, Object arg) {
        this.logger.debug(format, arg);
    }

    public void debug(String format, Object arg1, Object arg2) {
        this.logger.debug(format, arg1, arg2);
    }

    public void debug(String format, Object ... arguments) {
        this.logger.debug(format, arguments);
    }

    public void debug(String msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    public boolean isDebugEnabled(Marker marker) {
        return this.logger.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        this.logger.debug(marker, msg);
    }

    public void debug(Marker marker, String format, Object arg) {
        this.logger.debug(marker, format, arg);
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.debug(marker, format, arg1, arg2);
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        this.logger.debug(marker, format, arguments);
    }

    public void debug(Marker marker, String msg, Throwable t) {
        this.logger.debug(marker, msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(String msg) {
        this.logger.info(msg);
        this.logInfoToTaskDashboard(msg);
    }

    public void info(String format, Object arg) {
        this.logger.info(format, arg);
        this.logInfoToTaskDashboard(format, arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.logger.info(format, arg1, arg2);
        this.logInfoToTaskDashboard(format, arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.logger.info(format, arguments);
        this.logInfoToTaskDashboard(format, arguments);
    }

    public void info(String msg, Throwable t) {
        this.logger.info(msg, t);
        this.logInfoToTaskDashboard(msg);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.logger.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.logger.info(marker, msg);
        this.logInfoToTaskDashboard(msg);
    }

    public void info(Marker marker, String format, Object arg) {
        this.logger.info(marker, format, arg);
        this.logInfoToTaskDashboard(format, arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.info(marker, format, arg1, arg2);
        this.logInfoToTaskDashboard(format, arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.logger.info(marker, format, arguments);
        this.logInfoToTaskDashboard(format, arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.logger.info(marker, msg, t);
        this.logInfoToTaskDashboard(msg);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public void warn(String msg) {
        this.logger.warn(msg);
        this.logWarnToTaskDashboard(msg);
    }

    public void warn(String format, Object arg) {
        this.logger.warn(format, arg);
        this.logWarnToTaskDashboard(format, arg);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.logger.warn(format, arg1, arg2);
        this.logWarnToTaskDashboard(format, arg1, arg2);
    }

    public void warn(String format, Object ... arguments) {
        this.logger.warn(format, arguments);
        this.logWarnToTaskDashboard(format, arguments);
    }

    public void warn(String msg, Throwable t) {
        this.logger.warn(msg, t);
        this.logWarnToTaskDashboard(msg);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.logger.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.logger.warn(marker, msg);
        this.logWarnToTaskDashboard(msg);
    }

    public void warn(Marker marker, String format, Object arg) {
        this.logger.warn(marker, format, arg);
        this.logWarnToTaskDashboard(format, arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.warn(marker, format, arg1, arg2);
        this.logWarnToTaskDashboard(format, arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.logger.warn(marker, format, arguments);
        this.logWarnToTaskDashboard(format, arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.logger.warn(marker, msg, t);
        this.logWarnToTaskDashboard(msg);
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public void error(String msg) {
        this.logger.error(msg);
        this.logErrorToTaskDashboard(msg);
    }

    public void error(String format, Object arg) {
        this.logger.error(format, arg);
        this.logErrorToTaskDashboard(format, arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.logger.error(format, arg1, arg2);
        this.logErrorToTaskDashboard(format, arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.logger.error(format, arguments);
        this.logErrorToTaskDashboard(format, arguments);
    }

    public void error(String msg, Throwable t) {
        this.logger.error(msg, t);
        this.logErrorToTaskDashboard(msg);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.logger.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.logger.error(marker, msg);
        this.logErrorToTaskDashboard(msg);
    }

    public void error(Marker marker, String format, Object arg) {
        this.logger.error(marker, format, arg);
        this.logErrorToTaskDashboard(format, arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.logger.error(marker, format, arg1, arg2);
        this.logErrorToTaskDashboard(format, arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.logger.error(marker, format, arguments);
        this.logErrorToTaskDashboard(format, arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.logger.error(marker, msg, t);
        this.logErrorToTaskDashboard(msg);
    }

    private void logInfoToTaskDashboard(String message) {
        if (this.threshold.compareTo(TaskDashboardLogger.Level.INFO) > 0) {
            return;
        }
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().info(message);
        }
    }

    private void logInfoToTaskDashboard(String format, Object ... args) {
        if (this.threshold.compareTo(TaskDashboardLogger.Level.INFO) > 0) {
            return;
        }
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])args);
            taskDashboardLoggerThreadLocal.get().info(tp.getMessage());
        }
    }

    private void logWarnToTaskDashboard(String message) {
        if (this.threshold.compareTo(TaskDashboardLogger.Level.WARN) > 0) {
            return;
        }
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().warn(message);
        }
    }

    private void logWarnToTaskDashboard(String format, Object ... args) {
        if (this.threshold.compareTo(TaskDashboardLogger.Level.WARN) > 0) {
            return;
        }
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])args);
            taskDashboardLoggerThreadLocal.get().warn(tp.getMessage());
        }
    }

    private void logErrorToTaskDashboard(String message) {
        if (taskDashboardLoggerThreadLocal.get() != null) {
            taskDashboardLoggerThreadLocal.get().error(message);
        }
    }

    private void logErrorToTaskDashboard(String format, Object ... args) {
        if (taskDashboardLoggerThreadLocal.get() != null) {
            FormattingTuple tp = MessageFormatter.arrayFormat((String)format, (Object[])args);
            taskDashboardLoggerThreadLocal.get().error(tp.getMessage());
        }
    }
}

