/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskDashboardLogger;
import cn.boboweike.carrot.tasks.context.TaskDashboardProgressBar;
import cn.boboweike.carrot.tasks.states.StateName;
import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class TaskContext {
    public static final TaskContext Null = new TaskContext(null);
    private final Task task;
    private TaskDashboardLogger taskDashboardLogger;
    private TaskDashboardProgressBar taskDashboardProgressBar;

    protected TaskContext() {
        this(null);
    }

    protected TaskContext(Task task) {
        this.task = task;
    }

    public UUID getTaskId() {
        return this.task.getId();
    }

    public String getTaskName() {
        return this.task.getTaskName();
    }

    public StateName getTaskState() {
        return this.task.getState();
    }

    public Instant getCreatedAt() {
        return this.task.getCreatedAt();
    }

    public Instant getUpdatedAt() {
        return this.task.getUpdatedAt();
    }

    public String getSignature() {
        return this.task.getTaskSignature();
    }

    public TaskDashboardLogger logger() {
        if (this.taskDashboardLogger == null) {
            this.taskDashboardLogger = new TaskDashboardLogger(this.task);
        }
        return this.taskDashboardLogger;
    }

    public TaskDashboardProgressBar progressBar(int totalAmount) {
        return this.progressBar((long)totalAmount);
    }

    public TaskDashboardProgressBar progressBar(long totalAmount) {
        if (this.taskDashboardProgressBar == null) {
            this.taskDashboardProgressBar = new TaskDashboardProgressBar(this.task, totalAmount);
        }
        return this.taskDashboardProgressBar;
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.task.getMetadata().entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("carrotDashboardLog")).filter(entry -> !((String)entry.getKey()).startsWith("carrotDashboardProgressBar")).filter(entry -> !((String)entry.getKey()).startsWith("mdc")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
    }

    public void saveMetadata(String key, Object metadata) {
        TaskContext.validateMetadata(metadata);
        this.task.getMetadata().put(key, metadata);
    }

    public void saveMetadataIfAbsent(String key, Object metadata) {
        TaskContext.validateMetadata(metadata);
        this.task.getMetadata().putIfAbsent(key, metadata);
    }

    private static void validateMetadata(Object metadata) {
        if (!metadata.getClass().getName().startsWith("java.") && !(metadata instanceof Metadata)) {
            throw new IllegalArgumentException("All task metadata must either be a simple type (String, UUID, Integers, ...) or implement the Metadata interface for serialization to Json.");
        }
    }

    public static interface Metadata {
    }
}

