/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.time.Instant;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TaskDashboardLogger {
    public static final String CARROT_LOG_KEY = "carrotDashboardLog";
    private final TaskDashboardLogLines logLines;

    public TaskDashboardLogger(Task task) {
        this.logLines = this.initLogLines(task);
    }

    public void info(String infoMessage) {
        this.logLines.add(new TaskDashboardLogLine(Level.INFO, infoMessage));
    }

    public void warn(String warnMessage) {
        this.logLines.add(new TaskDashboardLogLine(Level.WARN, warnMessage));
    }

    public void error(String errorMessage) {
        this.logLines.add(new TaskDashboardLogLine(Level.ERROR, errorMessage));
    }

    private TaskDashboardLogLines initLogLines(Task task) {
        Map<String, Object> taskMetadata = task.getMetadata();
        String logKey = TaskDashboardLogger.logKey(task.getTaskStates().size());
        taskMetadata.putIfAbsent(logKey, new TaskDashboardLogLines());
        return (TaskDashboardLogLines)ReflectionUtils.cast(taskMetadata.get(logKey));
    }

    private static String logKey(int taskStateNbr) {
        return "carrotDashboardLog-" + taskStateNbr;
    }

    public static class TaskDashboardLogLine {
        private Level level;
        private Instant logInstant;
        private String logMessage;

        protected TaskDashboardLogLine() {
        }

        public TaskDashboardLogLine(Level level, String logMessage) {
            this.level = level;
            this.logInstant = Instant.now();
            this.logMessage = logMessage;
        }

        public Level getLevel() {
            return this.level;
        }

        public Instant getLogInstant() {
            return this.logInstant;
        }

        public String getLogMessage() {
            return this.logMessage;
        }
    }

    public static class TaskDashboardLogLines
    implements TaskContext.Metadata {
        private ConcurrentLinkedQueue<TaskDashboardLogLine> logLines = new ConcurrentLinkedQueue();

        public void add(TaskDashboardLogLine line) {
            this.logLines.add(line);
        }

        public Queue<TaskDashboardLogLine> getLogLines() {
            return this.logLines;
        }
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

