/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.context;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.context.TaskContext;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.Map;

public class TaskDashboardProgressBar {
    public static final String CARROT_PROGRESSBAR_KEY = "carrotDashboardProgressBar";
    private final TaskDashboardProgress taskDashboardProgress;

    public TaskDashboardProgressBar(Task task, Long totalAmount) {
        this.taskDashboardProgress = this.initTaskDashboardProgress(task, totalAmount);
    }

    private TaskDashboardProgress initTaskDashboardProgress(Task task, Long totalAmount) {
        Map<String, Object> taskMetadata = task.getMetadata();
        String progressBarKey = TaskDashboardProgressBar.progressBarKey(task.getTaskStates().size());
        taskMetadata.putIfAbsent(progressBarKey, new TaskDashboardProgress(totalAmount));
        return (TaskDashboardProgress)ReflectionUtils.cast(taskMetadata.get(progressBarKey));
    }

    public void increaseByOne() {
        this.taskDashboardProgress.increaseByOne();
    }

    public int getProgress() {
        return this.taskDashboardProgress.getProgress();
    }

    public void setValue(int currentProgress) {
        this.setValue((long)currentProgress);
    }

    public void setValue(long currentProgress) {
        this.taskDashboardProgress.setCurrentValue(currentProgress);
    }

    private static String progressBarKey(int taskStateNbr) {
        return "carrotDashboardProgressBar-" + taskStateNbr;
    }

    private static class TaskDashboardProgress
    implements TaskContext.Metadata {
        private Long totalAmount;
        private Long currentValue;
        private int progress;

        protected TaskDashboardProgress() {
        }

        public TaskDashboardProgress(Long totalAmount) {
            if (totalAmount < 1L) {
                throw new IllegalArgumentException("The total progress amount must be larger than 0.");
            }
            this.totalAmount = totalAmount;
            this.currentValue = 0L;
        }

        public void increaseByOne() {
            this.setCurrentValue(this.currentValue + 1L);
        }

        public void setCurrentValue(Long currentValue) {
            this.currentValue = currentValue;
            this.progress = (int)(currentValue * 100L / this.totalAmount);
        }

        public int getProgress() {
            return this.progress;
        }
    }
}

