/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.instructions.AllJVMInstructions;
import cn.boboweike.carrot.tasks.details.instructions.InvokeDynamicInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LdcInstruction;
import cn.boboweike.carrot.tasks.details.instructions.SingleIntOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.VisitFieldInstruction;
import cn.boboweike.carrot.tasks.details.instructions.VisitLocalVariableInstruction;
import cn.boboweike.carrot.tasks.details.instructions.VisitMethodInstruction;
import cn.boboweike.carrot.tasks.details.instructions.VisitTypeInstruction;
import cn.boboweike.carrot.tasks.details.instructions.ZeroOperandInstruction;
import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.MethodVisitor;

abstract class AbstractTaskDetailsFinder
extends ClassVisitor {
    protected final TaskDetailsBuilder taskDetailsBuilder;

    protected AbstractTaskDetailsFinder(TaskDetailsBuilder taskDetailsBuilder) {
        super(458752);
        this.taskDetailsBuilder = taskDetailsBuilder;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
        if (this.isLambdaContainingTaskDetails(name)) {
            return new MethodVisitor(458752){

                public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                    VisitFieldInstruction instruction = (VisitFieldInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    instruction.load(owner, name, descriptor);
                }

                public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                    InvokeDynamicInstruction instruction = (InvokeDynamicInstruction)AllJVMInstructions.get(186, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    instruction.load(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
                }

                public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                    VisitMethodInstruction visitMethodInstruction = (VisitMethodInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    visitMethodInstruction.load(owner, name, descriptor, isInterface);
                }

                public void visitInsn(int opcode) {
                    ZeroOperandInstruction zeroOperandInstruction = (ZeroOperandInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    zeroOperandInstruction.load();
                }

                public void visitVarInsn(int opcode, int variable) {
                    VisitLocalVariableInstruction instruction = (VisitLocalVariableInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    instruction.load(variable);
                }

                public void visitIntInsn(int opcode, int operand) {
                    SingleIntOperandInstruction singleIntOperandInstruction = (SingleIntOperandInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    singleIntOperandInstruction.load(operand);
                }

                public void visitLdcInsn(Object value) {
                    LdcInstruction ldcInstruction = (LdcInstruction)AllJVMInstructions.get(18, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    ldcInstruction.load(value);
                }

                public void visitTypeInsn(int opcode, String type) {
                    VisitTypeInstruction instruction = (VisitTypeInstruction)AllJVMInstructions.get(opcode, AbstractTaskDetailsFinder.this.taskDetailsBuilder);
                    instruction.load(type);
                }
            };
        }
        return super.visitMethod(access, name, descriptor, signature, exceptions);
    }

    protected abstract boolean isLambdaContainingTaskDetails(String var1);

    protected abstract InputStream getClassContainingLambdaAsInputStream();

    public TaskDetails getTaskDetails() {
        return this.taskDetailsBuilder.getTaskDetails();
    }

    protected void parse(InputStream inputStream) {
        try {
            ClassReader parser = new ClassReader(inputStream);
            parser.accept((ClassVisitor)this, 4);
        }
        catch (IOException e) {
            throw CarrotException.shouldNotHappenException(e);
        }
    }
}

