/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.details.TaskDetailsAsmGenerator;
import cn.boboweike.carrot.tasks.details.TaskDetailsGenerator;
import cn.boboweike.carrot.tasks.lambdas.CarrotTask;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambda;
import cn.boboweike.carrot.tasks.lambdas.IocTaskLambdaFromStream;
import cn.boboweike.carrot.tasks.lambdas.TaskLambda;
import cn.boboweike.carrot.tasks.lambdas.TaskLambdaFromStream;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;

public class CachingTaskDetailsGenerator
implements TaskDetailsGenerator {
    private final TaskDetailsGenerator delegate;
    private final Map<Class<?>, CacheableTaskDetails> cache;

    public CachingTaskDetailsGenerator() {
        this(new TaskDetailsAsmGenerator());
    }

    public CachingTaskDetailsGenerator(TaskDetailsGenerator delegate) {
        this.delegate = delegate;
        this.cache = new ConcurrentHashMap();
    }

    @Override
    public TaskDetails toTaskDetails(TaskLambda lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableTaskDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getTaskDetails(lambda);
    }

    @Override
    public TaskDetails toTaskDetails(IocTaskLambda<?> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableTaskDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getTaskDetails(lambda);
    }

    @Override
    public <T> TaskDetails toTaskDetails(T itemFromStream, TaskLambdaFromStream<T> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableTaskDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getTaskDetails(itemFromStream, lambda);
    }

    @Override
    public <S, T> TaskDetails toTaskDetails(T itemFromStream, IocTaskLambdaFromStream<S, T> lambda) {
        this.cache.computeIfAbsent(lambda.getClass(), clazz -> new CacheableTaskDetails(this.delegate));
        return this.cache.get(lambda.getClass()).getTaskDetails(itemFromStream, lambda);
    }

    private static class ItemFromStreamTaskParameterRetriever
    implements TaskParameterRetriever {
        private final String taskParameterClassName;

        public ItemFromStreamTaskParameterRetriever(TaskParameter taskParameter) {
            this.taskParameterClassName = taskParameter.getClassName();
        }

        @Override
        public <T> TaskParameter getTaskParameter(CarrotTask task, Optional<T> itemFromStream) {
            return new TaskParameter(this.taskParameterClassName, itemFromStream.orElseThrow(() -> CarrotException.shouldNotHappenException("Can not find itemFromStream")));
        }
    }

    private static class MethodHandleTaskParameterRetriever
    implements TaskParameterRetriever {
        private final String taskParameterClassName;
        private final MethodHandle methodHandle;

        public MethodHandleTaskParameterRetriever(TaskParameter taskParameter, MethodHandle methodHandle) {
            this.taskParameterClassName = taskParameter.getClassName();
            this.methodHandle = methodHandle;
        }

        @Override
        public <T> TaskParameter getTaskParameter(CarrotTask task, Optional<T> itemFromStream) {
            try {
                Object o = this.methodHandle.invokeExact(task);
                return new TaskParameter(this.taskParameterClassName, o);
            }
            catch (Throwable throwable) {
                throw CarrotException.shouldNotHappenException(throwable);
            }
        }
    }

    private static class FixedTaskParameterRetriever
    implements TaskParameterRetriever {
        private final TaskParameter taskParameter;

        public FixedTaskParameterRetriever(TaskParameter taskParameter) {
            this.taskParameter = taskParameter;
        }

        @Override
        public <T> TaskParameter getTaskParameter(CarrotTask task, Optional<T> itemFromStream) {
            return this.taskParameter;
        }
    }

    private static interface TaskParameterRetriever {
        public <T> TaskParameter getTaskParameter(CarrotTask var1, Optional<T> var2);
    }

    private static class CacheableTaskDetails {
        private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
        private final TaskDetailsGenerator taskDetailsGeneratorDelegate;
        private final ReentrantLock taskDetailsLock;
        private TaskDetails taskDetails;
        private List<TaskParameterRetriever> taskParameterRetrievers;

        private CacheableTaskDetails(TaskDetailsGenerator taskDetailsGeneratorDelegate) {
            this.taskDetailsGeneratorDelegate = taskDetailsGeneratorDelegate;
            this.taskDetailsLock = new ReentrantLock();
        }

        public TaskDetails getTaskDetails(TaskLambda lambda) {
            if (this.taskDetails == null) {
                this.taskDetailsLock.lock();
                try {
                    this.taskDetails = this.taskDetailsGeneratorDelegate.toTaskDetails(lambda);
                    this.taskParameterRetrievers = CacheableTaskDetails.initTaskParameterRetrievers(this.taskDetails, lambda, Optional.empty());
                    TaskDetails taskDetails = this.taskDetails;
                    return taskDetails;
                }
                finally {
                    this.taskDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.taskDetails.getCacheable())) {
                return this.getCachedTaskDetails(lambda, Optional.empty());
            }
            return this.taskDetailsGeneratorDelegate.toTaskDetails(lambda);
        }

        public TaskDetails getTaskDetails(IocTaskLambda lambda) {
            if (this.taskDetails == null) {
                this.taskDetailsLock.lock();
                try {
                    this.taskDetails = this.taskDetailsGeneratorDelegate.toTaskDetails(lambda);
                    this.taskParameterRetrievers = CacheableTaskDetails.initTaskParameterRetrievers(this.taskDetails, lambda, Optional.empty());
                    TaskDetails taskDetails = this.taskDetails;
                    return taskDetails;
                }
                finally {
                    this.taskDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.taskDetails.getCacheable())) {
                return this.getCachedTaskDetails(lambda, Optional.empty());
            }
            return this.taskDetailsGeneratorDelegate.toTaskDetails(lambda);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> TaskDetails getTaskDetails(T itemFromStream, TaskLambdaFromStream<T> lambda) {
            if (this.taskDetails == null) {
                this.taskDetailsLock.lock();
                try {
                    this.taskDetails = this.taskDetailsGeneratorDelegate.toTaskDetails(itemFromStream, lambda);
                    this.taskParameterRetrievers = CacheableTaskDetails.initTaskParameterRetrievers(this.taskDetails, lambda, Optional.of(itemFromStream));
                    TaskDetails taskDetails = this.taskDetails;
                    return taskDetails;
                }
                finally {
                    this.taskDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.taskDetails.getCacheable())) {
                return this.getCachedTaskDetails(lambda, Optional.of(itemFromStream));
            }
            return this.taskDetailsGeneratorDelegate.toTaskDetails(itemFromStream, lambda);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <S, T> TaskDetails getTaskDetails(T itemFromStream, IocTaskLambdaFromStream<S, T> lambda) {
            if (this.taskDetails == null) {
                this.taskDetailsLock.lock();
                try {
                    this.taskDetails = this.taskDetailsGeneratorDelegate.toTaskDetails(itemFromStream, lambda);
                    this.taskParameterRetrievers = CacheableTaskDetails.initTaskParameterRetrievers(this.taskDetails, lambda, Optional.of(itemFromStream));
                    TaskDetails taskDetails = this.taskDetails;
                    return taskDetails;
                }
                finally {
                    this.taskDetailsLock.unlock();
                }
            }
            if (Boolean.TRUE.equals(this.taskDetails.getCacheable())) {
                return this.getCachedTaskDetails(lambda, Optional.of(itemFromStream));
            }
            return this.taskDetailsGeneratorDelegate.toTaskDetails(itemFromStream, lambda);
        }

        private static <T> List<TaskParameterRetriever> initTaskParameterRetrievers(TaskDetails taskDetails, CarrotTask carrotTask, Optional<T> itemFromStream) {
            try {
                ArrayList<TaskParameterRetriever> parameterRetrievers = new ArrayList<TaskParameterRetriever>();
                ArrayList<Field> declaredFields = new ArrayList<Field>(Arrays.asList(carrotTask.getClass().getDeclaredFields()));
                List<TaskParameter> taskParameters = taskDetails.getTaskParameters();
                if (!declaredFields.isEmpty() && !((Field)declaredFields.get(0)).getType().getName().startsWith("java.") && (carrotTask instanceof TaskLambda || carrotTask instanceof TaskLambdaFromStream)) {
                    declaredFields.remove(0);
                }
                for (TaskParameter tp : taskParameters) {
                    parameterRetrievers.add(CacheableTaskDetails.createTaskParameterRetriever(tp, carrotTask, itemFromStream, declaredFields));
                }
                taskDetails.setCacheable(declaredFields.isEmpty() && taskParameters.size() == parameterRetrievers.size());
                return parameterRetrievers;
            }
            catch (Exception e) {
                taskDetails.setCacheable(false);
                return Collections.emptyList();
            }
        }

        private static <T> TaskParameterRetriever createTaskParameterRetriever(TaskParameter tp, CarrotTask carrotTask, Optional<T> itemFromStream, List<Field> declaredFields) throws IllegalAccessException {
            TaskParameterRetriever taskParameterRetriever = new FixedTaskParameterRetriever(tp);
            if (itemFromStream.isPresent() && tp.getObject().equals(itemFromStream.get())) {
                taskParameterRetriever = new ItemFromStreamTaskParameterRetriever(tp);
            } else {
                ListIterator<Field> fieldIterator = declaredFields.listIterator();
                while (fieldIterator.hasNext()) {
                    Field f = fieldIterator.next();
                    Object valueFromField = ReflectionUtils.getValueFromField(f, carrotTask);
                    if (!tp.getObject().equals(valueFromField)) continue;
                    MethodHandle e = lookup.unreflectGetter(f);
                    taskParameterRetriever = new MethodHandleTaskParameterRetriever(tp, e.asType(e.type().generic()));
                    fieldIterator.remove();
                    break;
                }
            }
            return taskParameterRetriever;
        }

        private <T> TaskDetails getCachedTaskDetails(CarrotTask task, Optional<T> itemFromStream) {
            TaskDetails cachedTaskDetails = new TaskDetails(this.taskDetails.getClassName(), this.taskDetails.getStaticFieldName(), this.taskDetails.getMethodName(), this.taskParameterRetrievers.stream().map(taskParameterRetriever -> taskParameterRetriever.getTaskParameter(task, itemFromStream)).collect(Collectors.toList()));
            cachedTaskDetails.setCacheable(true);
            return cachedTaskDetails;
        }
    }
}

