/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.details.AbstractTaskDetailsFinder;
import cn.boboweike.carrot.tasks.details.JavaTaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.lambdas.CarrotTask;
import cn.boboweike.carrot.utils.StringUtils;
import java.io.InputStream;
import java.lang.invoke.SerializedLambda;
import java.util.Arrays;

public class JavaTaskDetailsFinder
extends AbstractTaskDetailsFinder {
    private final CarrotTask carrotTask;
    private final SerializedLambda serializedLambda;
    private final boolean isLambda;

    JavaTaskDetailsFinder(CarrotTask carrotTask, SerializedLambda serializedLambda, Object ... params) {
        super(new JavaTaskDetailsBuilder(serializedLambda, params));
        this.carrotTask = carrotTask;
        this.serializedLambda = serializedLambda;
        boolean bl = this.isLambda = serializedLambda.getImplMethodName().startsWith("lambda$") || serializedLambda.getImplMethodName().contains("$lambda-");
        if (this.isLambda) {
            this.parse(this.getClassContainingLambdaAsInputStream());
        } else if (serializedLambda.getCapturedArgCount() == 1 && Arrays.stream(serializedLambda.getCapturedArg(0).getClass().getAnnotations()).anyMatch(ann -> "kotlin.Metadata".equals(ann.annotationType().getName()))) {
            this.taskDetailsBuilder.setClassName(serializedLambda.getCapturedArg(0).getClass().getName());
            this.taskDetailsBuilder.setMethodName(serializedLambda.getImplMethodName().contains("$") ? StringUtils.substringAfter(serializedLambda.getImplMethodName(), "$") : serializedLambda.getImplMethodName());
        }
    }

    @Override
    protected boolean isLambdaContainingTaskDetails(String name) {
        return this.isLambda && name.equals(this.serializedLambda.getImplMethodName());
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return TaskDetailsGeneratorUtils.getJavaClassContainingLambdaAsInputStream(this.carrotTask);
    }
}

