/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.tasks.details.AbstractTaskDetailsFinder;
import cn.boboweike.carrot.tasks.details.KotlinTaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.lambdas.CarrotTask;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Optional;
import org.objectweb.asm.AnnotationVisitor;

public class KotlinTaskDetailsFinder
extends AbstractTaskDetailsFinder {
    private static final String INVOKE = "invoke";
    private static final String ACCEPT = "accept";
    private static final String RUN = "run";
    private final CarrotTask carrotTask;
    private int methodCounter = 0;
    private KotlinVersion kotlinVersion;
    private String nestedKotlinClassWithMethodReference;

    KotlinTaskDetailsFinder(CarrotTask carrotTask, Object ... params) {
        super(new KotlinTaskDetailsBuilder(carrotTask, params));
        this.carrotTask = carrotTask;
        this.parse(this.getClassContainingLambdaAsInputStream());
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return new AnnotationVisitor(458752){

            public void visit(String name, Object value) {
                if ("mv".equals(name)) {
                    int[] version = (int[])ReflectionUtils.cast(value);
                    if (version[0] == 1 && version[1] == 4) {
                        KotlinTaskDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_FOUR;
                    } else if (version[0] == 1 && version[1] == 5) {
                        KotlinTaskDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_FIVE;
                    } else if (version[0] == 1 && version[1] == 6) {
                        KotlinTaskDetailsFinder.this.kotlinVersion = KotlinVersion.ONE_SIX;
                    } else {
                        throw new UnsupportedOperationException("The Kotlin version " + version[0] + "." + version[1] + " is unsupported");
                    }
                }
            }
        };
    }

    @Override
    protected boolean isLambdaContainingTaskDetails(String name) {
        if (name.equals(ACCEPT) || name.equals(INVOKE)) {
            ++this.methodCounter;
        }
        if (KotlinVersion.ONE_FOUR.equals((Object)this.kotlinVersion)) {
            return name.equals(RUN) || (name.equals(ACCEPT) || name.equals(INVOKE)) && this.methodCounter == 2;
        }
        return name.equals(RUN) || (name.equals(ACCEPT) || name.equals(INVOKE)) && this.methodCounter == 1;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (access == 4120 || access == 4096) {
            this.nestedKotlinClassWithMethodReference = name;
        }
    }

    @Override
    protected InputStream getClassContainingLambdaAsInputStream() {
        return TaskDetailsGeneratorUtils.getKotlinClassContainingLambdaAsInputStream(this.carrotTask);
    }

    @Override
    protected void parse(InputStream inputStream) {
        Optional<Field> field = ReflectionUtils.findField(this.carrotTask.getClass(), "function");
        if (field.isPresent()) {
            this.getTaskDetailsFromKotlinFunction(field.get());
        } else {
            super.parse(inputStream);
            this.parseNestedClassIfItIsAMethodReference();
        }
    }

    private void getTaskDetailsFromKotlinFunction(Field field) {
        Object function = ReflectionUtils.getValueFromField(field, this.carrotTask);
        Field receiver = ReflectionUtils.getField(function.getClass(), "receiver");
        Field name = ReflectionUtils.getField(function.getClass(), "name");
        Class<?> receiverClass = ReflectionUtils.getValueFromField(receiver, function).getClass();
        String methodName = (String)ReflectionUtils.cast(ReflectionUtils.getValueFromField(name, function));
        this.taskDetailsBuilder.setClassName(receiverClass.getName());
        this.taskDetailsBuilder.setMethodName(methodName);
    }

    private void parseNestedClassIfItIsAMethodReference() {
        boolean isNestedKotlinClassWithMethodReference;
        boolean bl = isNestedKotlinClassWithMethodReference = this.nestedKotlinClassWithMethodReference != null && !TaskDetailsGeneratorUtils.toFQResource(this.carrotTask.getClass().getName()).equals(this.nestedKotlinClassWithMethodReference);
        if (isNestedKotlinClassWithMethodReference) {
            String location = "/" + this.nestedKotlinClassWithMethodReference + ".class";
            super.parse(this.carrotTask.getClass().getResourceAsStream(location));
            while (this.taskDetailsBuilder.getInstructions().size() > 1) {
                this.taskDetailsBuilder.pollFirstInstruction();
            }
        }
    }

    private static enum KotlinVersion {
        ONE_FOUR,
        ONE_FIVE,
        ONE_SIX;

    }
}

