/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;

public class SerializedLambdaConverter {
    private SerializedLambdaConverter() {
    }

    public static <T> SerializedLambda toSerializedLambda(T value) {
        if (!value.getClass().isSynthetic()) {
            throw new IllegalArgumentException("Please provide a lambda expression (e.g. BackgroundTask.enqueue(() -> myService.doWork()) instead of an actual implementation.");
        }
        if (!(value instanceof Serializable)) {
            throw new CarrotException("The lambda you provided is not Serializable. Please make sure your functional interface is Serializable or use the TaskLambda interface instead.");
        }
        try {
            Method writeReplaceMethod = value.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            ReflectionUtils.makeAccessible(writeReplaceMethod);
            return (SerializedLambda)writeReplaceMethod.invoke(value, new Object[0]);
        }
        catch (Exception shouldNotHappen) {
            throw CarrotException.shouldNotHappenException(shouldNotHappen);
        }
    }
}

