/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskDetails;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.details.instructions.AbstractJVMInstruction;
import cn.boboweike.carrot.tasks.details.postprocess.CGLibPostProcessor;
import cn.boboweike.carrot.tasks.details.postprocess.TaskDetailsPostProcessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class TaskDetailsBuilder {
    private final LinkedList<AbstractJVMInstruction> instructions = new LinkedList();
    private final LinkedList<Object> stack = new LinkedList();
    private final List<Object> localVariables;
    private String taskDetailsClassName;
    private String taskDetailsStaticFieldName;
    private String taskDetailsMethodName;
    private List<TaskParameter> taskDetailsTaskParameters;
    private List<TaskDetailsPostProcessor> taskDetailsPostProcessors;

    protected TaskDetailsBuilder(List<Object> localVariables) {
        this(localVariables, null, null);
    }

    protected TaskDetailsBuilder(List<Object> localVariables, String className, String methodName) {
        this.localVariables = localVariables;
        this.setClassName(className);
        this.setMethodName(methodName);
        this.setTaskParameters(new ArrayList<TaskParameter>());
        this.taskDetailsPostProcessors = Collections.singletonList(new CGLibPostProcessor());
    }

    public void pushInstructionOnStack(AbstractJVMInstruction jvmInstruction) {
        this.instructions.add(jvmInstruction);
    }

    public Object getLocalVariable(int nbrInStack) {
        if (nbrInStack < this.localVariables.size()) {
            return this.localVariables.get(nbrInStack);
        }
        throw CarrotException.shouldNotHappenException("Can not find variable " + nbrInStack + " in stack");
    }

    public void addLocalVariable(Object o) {
        this.localVariables.add(o);
    }

    public List<AbstractJVMInstruction> getInstructions() {
        return this.instructions;
    }

    public AbstractJVMInstruction pollFirstInstruction() {
        return this.instructions.pollFirst();
    }

    public LinkedList<Object> getStack() {
        return this.stack;
    }

    public TaskDetails getTaskDetails() {
        this.invokeInstructions();
        TaskDetails taskDetails = new TaskDetails(this.taskDetailsClassName, this.taskDetailsStaticFieldName, this.taskDetailsMethodName, this.taskDetailsTaskParameters);
        return this.postProcessTaskDetails(taskDetails);
    }

    private TaskDetails postProcessTaskDetails(TaskDetails taskDetails) {
        TaskDetails currentTaskDetails = taskDetails;
        for (TaskDetailsPostProcessor postProcessor : this.getTaskDetailsPostProcessors()) {
            currentTaskDetails = postProcessor.postProcess(currentTaskDetails);
        }
        return currentTaskDetails;
    }

    private void invokeInstructions() {
        if (this.instructions.isEmpty() && this.localVariables.size() > 1) {
            for (int i = 1; i < this.localVariables.size(); ++i) {
                Object variable = this.localVariables.get(i);
                this.taskDetailsTaskParameters.add(new TaskParameter(variable));
            }
        } else {
            AbstractJVMInstruction instruction = this.pollFirstInstruction();
            while (instruction != null) {
                instruction.invokeInstructionAndPushOnStack();
                instruction = this.pollFirstInstruction();
            }
        }
    }

    public void setClassName(String className) {
        if (this.taskDetailsStaticFieldName == null) {
            this.taskDetailsClassName = className;
        }
    }

    public void setStaticFieldName(String name) {
        this.taskDetailsStaticFieldName = name;
    }

    public void setMethodName(String name) {
        this.taskDetailsMethodName = name;
    }

    public void setTaskParameters(List<TaskParameter> taskParameters) {
        this.taskDetailsTaskParameters = taskParameters;
    }

    List<TaskDetailsPostProcessor> getTaskDetailsPostProcessors() {
        return this.taskDetailsPostProcessors;
    }
}

