/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.instructions.AAStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.ALoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.ANewArrayOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.AStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.AbstractJVMInstruction;
import cn.boboweike.carrot.tasks.details.instructions.CheckCastOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.DLoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.DStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.DupOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.FLoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.FStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.GetFieldInstruction;
import cn.boboweike.carrot.tasks.details.instructions.GetStaticInstruction;
import cn.boboweike.carrot.tasks.details.instructions.I2BOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.I2SOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst0OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst1OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst2OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst3OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst4OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IConst5OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.ILoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.IStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeDynamicInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeInterfaceInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeSpecialInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeStaticInstruction;
import cn.boboweike.carrot.tasks.details.instructions.InvokeVirtualInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LConst0OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LConst1OperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LLoadOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LStoreInstruction;
import cn.boboweike.carrot.tasks.details.instructions.LdcInstruction;
import cn.boboweike.carrot.tasks.details.instructions.NewOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.PopOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.ReturnOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.SingleIntOperandInstruction;
import cn.boboweike.carrot.tasks.details.instructions.SwapOperandInstruction;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class AllJVMInstructions {
    private static final Map<Integer, Function<TaskDetailsBuilder, AbstractJVMInstruction>> instructions = new HashMap<Integer, Function<TaskDetailsBuilder, AbstractJVMInstruction>>();
    private static final Map<Integer, String> unsupportedInstructions = new HashMap<Integer, String>();

    private AllJVMInstructions() {
    }

    public static <T extends AbstractJVMInstruction> T get(int opcode, TaskDetailsBuilder taskDetailsBuilder) {
        Function<TaskDetailsBuilder, AbstractJVMInstruction> instructionBuilder = instructions.get(opcode);
        if (instructionBuilder == null) {
            if (unsupportedInstructions.containsKey(opcode)) {
                throw new IllegalArgumentException("Unsupported lambda", new UnsupportedOperationException(unsupportedInstructions.get(opcode)));
            }
            throw CarrotException.shouldNotHappenException(new IllegalArgumentException("Instruction " + opcode + " not found"));
        }
        return (T)((AbstractJVMInstruction)ReflectionUtils.cast(instructionBuilder.apply(taskDetailsBuilder)));
    }

    static {
        instructions.put(83, AAStoreInstruction::new);
        instructions.put(25, ALoadOperandInstruction::new);
        instructions.put(189, ANewArrayOperandInstruction::new);
        instructions.put(58, AStoreInstruction::new);
        instructions.put(16, SingleIntOperandInstruction::new);
        instructions.put(192, CheckCastOperandInstruction::new);
        instructions.put(24, DLoadOperandInstruction::new);
        instructions.put(23, FLoadOperandInstruction::new);
        instructions.put(145, I2BOperandInstruction::new);
        instructions.put(147, I2SOperandInstruction::new);
        instructions.put(3, IConst0OperandInstruction::new);
        instructions.put(4, IConst1OperandInstruction::new);
        instructions.put(5, IConst2OperandInstruction::new);
        instructions.put(6, IConst3OperandInstruction::new);
        instructions.put(7, IConst4OperandInstruction::new);
        instructions.put(8, IConst5OperandInstruction::new);
        instructions.put(186, InvokeDynamicInstruction::new);
        instructions.put(185, InvokeInterfaceInstruction::new);
        instructions.put(183, InvokeSpecialInstruction::new);
        instructions.put(184, InvokeStaticInstruction::new);
        instructions.put(182, InvokeVirtualInstruction::new);
        instructions.put(54, IStoreInstruction::new);
        instructions.put(55, LStoreInstruction::new);
        instructions.put(57, DStoreInstruction::new);
        instructions.put(56, FStoreInstruction::new);
        instructions.put(89, DupOperandInstruction::new);
        instructions.put(95, SwapOperandInstruction::new);
        instructions.put(21, ILoadOperandInstruction::new);
        instructions.put(9, LConst0OperandInstruction::new);
        instructions.put(10, LConst1OperandInstruction::new);
        instructions.put(18, LdcInstruction::new);
        instructions.put(22, LLoadOperandInstruction::new);
        instructions.put(187, NewOperandInstruction::new);
        instructions.put(87, PopOperandInstruction::new);
        instructions.put(180, GetFieldInstruction::new);
        instructions.put(178, GetStaticInstruction::new);
        instructions.put(177, ReturnOperandInstruction::new);
        instructions.put(17, SingleIntOperandInstruction::new);
        String mathematicalPerformanceSuffix = " - for performance reasons it is better to do the calculation outside of the task lambda";
        Arrays.asList(96, 97, 98, 99).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are summing two numbers while enqueueing/scheduling tasks" + mathematicalPerformanceSuffix));
        Arrays.asList(100, 101, 102, 103).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are subtracting two numbers while enqueueing/scheduling tasks" + mathematicalPerformanceSuffix));
        Arrays.asList(104, 105, 106, 107).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are multiplying two numbers while enqueueing/scheduling tasks" + mathematicalPerformanceSuffix));
        Arrays.asList(108, 109, 110, 111).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are dividing two numbers while enqueueing/scheduling tasks" + mathematicalPerformanceSuffix));
        Arrays.asList(112, 113, 114, 115).forEach(instr -> unsupportedInstructions.put((Integer)instr, "You are calculating the remainder (%) for two numbers while enqueueing/scheduling tasks" + mathematicalPerformanceSuffix));
    }
}

