/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.details.instructions.VisitMethodInstruction;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;

public class InvokeSpecialInstruction
extends VisitMethodInstruction {
    public InvokeSpecialInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if ("<init>".equals(this.name)) {
            List<Object> parameters;
            Class<?>[] paramTypes;
            String className = TaskDetailsGeneratorUtils.toFQClassName(this.owner);
            Object objectViaConstructor = TaskDetailsGeneratorUtils.createObjectViaConstructor(className, paramTypes = TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor), (parameters = this.getParametersUsingParamTypes(paramTypes)).toArray());
            if (this.isKotlinMethodReference(objectViaConstructor)) {
                this.taskDetailsBuilder.setClassName(((Class)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "owner")).getName());
                this.taskDetailsBuilder.setMethodName((String)ReflectionUtils.getValueFromFieldOrProperty(objectViaConstructor, "name"));
            }
            return objectViaConstructor;
        }
        String className = TaskDetailsGeneratorUtils.toFQClassName(this.owner);
        Class objectClass = ReflectionUtils.toClass(className);
        Method method = ReflectionUtils.getMethod(objectClass, this.name, TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor));
        if (Modifier.isPrivate(method.getModifiers())) {
            throw CarrotException.invalidLambdaException(new IllegalAccessException(String.format("Carrot cannot access member \"%s\" of class %s with modifiers \"private\". Please make the method \"public\".", this.name, className)));
        }
        throw CarrotException.shouldNotHappenException("Unknown INVOKESPECIAL instruction: " + className + "." + this.name);
    }

    private boolean isKotlinMethodReference(Object objectViaConstructor) {
        return Arrays.stream(objectViaConstructor.getClass().getInterfaces()).map(Class::getName).anyMatch(name -> name.startsWith("kotlin.jvm.functions.Function"));
    }
}

