/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.details.instructions.AbstractJVMInstruction;
import cn.boboweike.carrot.tasks.details.instructions.VisitMethodInstruction;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvokeStaticInstruction
extends VisitMethodInstruction {
    private static final Logger LOGGER = LoggerFactory.getLogger(InvokeStaticInstruction.class);

    public InvokeStaticInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if (this.isLastInstruction()) {
            this.taskDetailsBuilder.setClassName(this.getClassName());
            this.taskDetailsBuilder.setMethodName(this.getMethodName());
            this.taskDetailsBuilder.setTaskParameters(this.getTaskParameters());
            return null;
        }
        long before = System.nanoTime();
        Object result = this.getObject();
        long after = System.nanoTime();
        if (after - before > 3000000L) {
            LOGGER.warn("You are using a custom method ({}.{}({})) while enqueueing that takes a lot of time. See https://www.boboweike.cn/carrot/documentation/background-methods/best-practices/ on how to use Carrot effectively.", new Object[]{this.getClassName(), this.getMethodName(), Stream.of(TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor)).map(Class::getSimpleName).collect(Collectors.joining(", "))});
        }
        return this.isVoidInstruction() ? AbstractJVMInstruction.DO_NOT_PUT_ON_STACK : result;
    }

    private Object getObject() {
        Class<?>[] paramTypes = TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor);
        List<Object> parameters = this.getParametersUsingParamTypes(paramTypes);
        if (this.isKotlinNullCheck()) {
            return null;
        }
        Object result = TaskDetailsGeneratorUtils.createObjectViaStaticMethod(this.getClassName(), this.getMethodName(), paramTypes, parameters.toArray());
        return result;
    }

    private boolean isKotlinNullCheck() {
        return this.getClassName().startsWith("kotlin.") && this.getMethodName().equals("checkNotNullParameter");
    }

    private String getMethodName() {
        return this.name;
    }

    private String getClassName() {
        return TaskDetailsGeneratorUtils.toFQClassName(this.owner);
    }

    private List<TaskParameter> getTaskParameters() {
        List<Class<?>> paramTypesFromDescriptor = TaskDetailsGeneratorUtils.findParamTypesFromDescriptor(this.descriptor);
        LinkedList paramTypes = new LinkedList(paramTypesFromDescriptor);
        ArrayList<TaskParameter> result = new ArrayList<TaskParameter>();
        while (!paramTypes.isEmpty()) {
            result.add(0, this.toTaskParameter(paramTypes.pollLast(), this.taskDetailsBuilder.getStack().pollLast()));
        }
        return result;
    }

    private TaskParameter toTaskParameter(Class<?> paramType, Object param) {
        if (ReflectionUtils.isClassAssignableToObject(paramType, param)) {
            if (Boolean.TYPE.equals(paramType) && Integer.class.equals(param.getClass())) {
                return new TaskParameter(paramType, (Object)((Integer)param > 0 ? 1 : 0));
            }
            return new TaskParameter(paramType, param);
        }
        throw CarrotException.shouldNotHappenException(new IllegalStateException("The found parameter types do not match the parameters."));
    }
}

