/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.tasks.TaskParameter;
import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.TaskDetailsGeneratorUtils;
import cn.boboweike.carrot.tasks.details.instructions.VisitMethodInstruction;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskDetailsInstruction
extends VisitMethodInstruction {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskDetailsInstruction.class);

    public TaskDetailsInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    @Override
    public Object invokeInstruction() {
        if (!this.isLastInstruction() && this.isVoidInstruction()) {
            throw new CarrotException("Carrot only supports enqueueing/scheduling of one method");
        }
        if (this.isLastInstruction()) {
            this.taskDetailsBuilder.setClassName(this.getClassName());
            this.taskDetailsBuilder.setMethodName(this.getMethodName());
            this.taskDetailsBuilder.setTaskParameters(this.getTaskParameters());
            return null;
        }
        if (this.owner.startsWith("java")) {
            return this.getObject();
        }
        long before = System.nanoTime();
        Object result = this.getObject();
        long after = System.nanoTime();
        if (after - before > 3000000L) {
            LOGGER.warn("You are using a custom method ({}.{}({})) while enqueueing that takes a lot of time. See https://www.boboweike.cn/carrot/documentation/background-methods/best-practices/ on how to use Carrot effectively.", new Object[]{this.getClassName(), this.getMethodName(), Stream.of(TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor)).map(Class::getSimpleName).collect(Collectors.joining(", "))});
        }
        return result;
    }

    String getClassName() {
        String className = TaskDetailsGeneratorUtils.toFQClassName(this.owner);
        if (this.taskDetailsBuilder.getStack().isEmpty()) {
            return this.findInheritedClassName(className).orElse(className);
        }
        Object taskOnStack = this.taskDetailsBuilder.getStack().getLast();
        if (taskOnStack == null) {
            return className;
        }
        Class taskClass = ReflectionUtils.toClass(className);
        if (taskClass.isAssignableFrom(taskOnStack.getClass())) {
            return taskOnStack.getClass().getName();
        }
        return className;
    }

    String getMethodName() {
        return this.name;
    }

    private Object getObject() {
        Class<?>[] paramTypes = TaskDetailsGeneratorUtils.findParamTypesFromDescriptorAsArray(this.descriptor);
        Object ownerObject = this.taskDetailsBuilder.getStack().remove(this.taskDetailsBuilder.getStack().size() - 1 - paramTypes.length);
        return TaskDetailsGeneratorUtils.createObjectViaMethod(ownerObject, this.name, paramTypes, this.getParametersUsingParamTypes(paramTypes).toArray());
    }

    private Optional<String> findInheritedClassName(String className) {
        if (this.taskDetailsBuilder.getLocalVariable(0) != null) {
            Field declaredField = this.taskDetailsBuilder.getLocalVariable(0).getClass().getDeclaredFields()[0];
            Object valueFromField = ReflectionUtils.getValueFromField(declaredField, this.taskDetailsBuilder.getLocalVariable(0));
            if (ReflectionUtils.toClass(className).isAssignableFrom(valueFromField.getClass())) {
                return Optional.of(valueFromField.getClass().getName());
            }
        }
        return Optional.empty();
    }

    private List<TaskParameter> getTaskParameters() {
        List<Class<?>> paramTypesFromDescriptor = TaskDetailsGeneratorUtils.findParamTypesFromDescriptor(this.descriptor);
        LinkedList paramTypes = new LinkedList(paramTypesFromDescriptor);
        ArrayList<TaskParameter> result = new ArrayList<TaskParameter>();
        while (!paramTypes.isEmpty()) {
            result.add(0, this.toTaskParameter(paramTypes.pollLast(), this.taskDetailsBuilder.getStack().pollLast()));
        }
        return result;
    }

    private TaskParameter toTaskParameter(Class<?> paramType, Object param) {
        if (param == null) {
            throw new NullPointerException("You are passing null as a parameter to your background task for type " + paramType.getName() + " - Carrot prevents this to fail fast.");
        }
        if (ReflectionUtils.isClassAssignableToObject(paramType, param)) {
            if (Boolean.TYPE.equals(paramType) && Integer.class.equals(param.getClass())) {
                return new TaskParameter(paramType, (Object)((Integer)param > 0 ? 1 : 0));
            }
            return new TaskParameter(paramType, param);
        }
        throw CarrotException.shouldNotHappenException(new IllegalStateException("The found parameter types do not match the parameters."));
    }
}

