/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.details.instructions;

import cn.boboweike.carrot.tasks.details.TaskDetailsBuilder;
import cn.boboweike.carrot.tasks.details.instructions.AbstractJVMInstruction;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public abstract class VisitMethodInstruction
extends AbstractJVMInstruction {
    protected String owner;
    protected String name;
    protected String descriptor;
    protected boolean isInterface;

    protected VisitMethodInstruction(TaskDetailsBuilder taskDetailsBuilder) {
        super(taskDetailsBuilder);
    }

    public void load(String owner, String name, String descriptor, boolean isInterface) {
        this.owner = owner;
        this.name = name;
        this.descriptor = descriptor;
        this.isInterface = isInterface;
        this.taskDetailsBuilder.pushInstructionOnStack(this);
    }

    protected boolean isVoidInstruction() {
        return this.descriptor.endsWith(")V");
    }

    protected boolean isLastInstruction() {
        return this.taskDetailsBuilder.getInstructions().isEmpty();
    }

    protected List<Object> getParametersUsingParamTypes(Class<?>[] paramTypesAsArray) {
        LinkedList paramTypes = new LinkedList(Arrays.asList(paramTypesAsArray));
        ArrayList<Object> result = new ArrayList<Object>();
        while (!paramTypes.isEmpty()) {
            Class<?> paramType = paramTypes.pollLast();
            result.add(0, ReflectionUtils.autobox(this.taskDetailsBuilder.getStack().pollLast(), paramType));
        }
        return result;
    }
}

