/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.CarrotException;
import cn.boboweike.carrot.scheduling.exceptions.TaskNotFoundException;
import cn.boboweike.carrot.tasks.AbstractTask;
import cn.boboweike.carrot.tasks.annotations.Task;
import cn.boboweike.carrot.tasks.filters.ElectStateFilter;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.utils.TaskUtils;
import cn.boboweike.carrot.utils.reflection.ReflectionUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public abstract class AbstractTaskFilters {
    protected final AbstractTask task;
    protected final List<TaskFilter> taskFilters;

    protected AbstractTaskFilters(AbstractTask task, TaskDefaultFilters taskDefaultFilters) {
        this.task = task;
        this.taskFilters = this.initTaskFilters(task, taskDefaultFilters.getFilters());
    }

    protected List<TaskFilter> initTaskFilters(AbstractTask task, List<TaskFilter> taskFilters) {
        try {
            ArrayList<TaskFilter> result = new ArrayList<TaskFilter>(taskFilters);
            AbstractTaskFilters.keepOnlyLastElectStateFilter(result);
            AbstractTaskFilters.addTaskFiltersFromTaskAnnotation(task, result);
            return result;
        }
        catch (TaskNotFoundException e) {
            return Collections.emptyList();
        }
    }

    abstract Logger getLogger();

    private static void keepOnlyLastElectStateFilter(List<TaskFilter> result) {
        if (AbstractTaskFilters.hasMultipleElectStateFilters(result)) {
            ElectStateFilter firstElectStateFilter = AbstractTaskFilters.findFirstElectStateFilter(result);
            result.remove(firstElectStateFilter);
        }
    }

    private static void addTaskFiltersFromTaskAnnotation(AbstractTask task, List<TaskFilter> result) {
        Optional<Task> taskAnnotation = TaskUtils.getTaskAnnotation(task.getTaskDetails());
        if (taskAnnotation.isPresent()) {
            Optional<ElectStateFilter> electStateFilter = AbstractTaskFilters.getElectStateFilter(taskAnnotation.get());
            if (electStateFilter.isPresent()) {
                result.removeIf(taskFilter -> ElectStateFilter.class.isAssignableFrom(taskFilter.getClass()));
                result.add(electStateFilter.get());
            }
            result.addAll(AbstractTaskFilters.getOtherTaskFilter(taskAnnotation.get()));
        }
    }

    private static boolean hasMultipleElectStateFilters(List<TaskFilter> result) {
        return result.stream().filter(taskFilter -> ElectStateFilter.class.isAssignableFrom(taskFilter.getClass())).count() > 1L;
    }

    private static ElectStateFilter findFirstElectStateFilter(List<TaskFilter> result) {
        return result.stream().filter(taskFilter -> ElectStateFilter.class.isAssignableFrom(taskFilter.getClass())).map(ElectStateFilter.class::cast).findFirst().orElseThrow(() -> CarrotException.shouldNotHappenException("Can not happen..."));
    }

    private static Optional<ElectStateFilter> getElectStateFilter(Task taskAnnotation) {
        return Stream.of(taskAnnotation.taskFilters()).filter(ElectStateFilter.class::isAssignableFrom).findFirst().map(ReflectionUtils::newInstance).map(ElectStateFilter.class::cast);
    }

    private static List<TaskFilter> getOtherTaskFilter(Task taskAnnotation) {
        return Stream.of(taskAnnotation.taskFilters()).filter(taskFilter -> !ElectStateFilter.class.isAssignableFrom((Class<?>)taskFilter)).map(ReflectionUtils::newInstance).collect(Collectors.toList());
    }

    <T extends TaskFilter> Consumer<T> catchThrowable(Consumer<T> consumer) {
        return taskClientFilter -> {
            try {
                consumer.accept(taskClientFilter);
            }
            catch (Exception e) {
                this.getLogger().error("Error evaluating taskfilter {}", (Object)taskClientFilter.getClass().getName(), (Object)e);
            }
        };
    }
}

