/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.ElectStateFilter;
import cn.boboweike.carrot.tasks.states.FailedState;
import cn.boboweike.carrot.tasks.states.StateName;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.TaskUtils;
import java.time.Instant;

public class RetryFilter
implements ElectStateFilter {
    public static final int DEFAULT_BACKOFF_POLICY_TIME_SEED = 3;
    public static final int DEFAULT_NBR_OF_RETRIES = 10;
    private final int numberOfRetries;
    private final int backOffPolicyTimeSeed;

    public RetryFilter() {
        this(10);
    }

    public RetryFilter(int numberOfRetries) {
        this(numberOfRetries, 3);
    }

    public RetryFilter(int numberOfRetries, int backOffPolicyTimeSeed) {
        this.numberOfRetries = numberOfRetries;
        this.backOffPolicyTimeSeed = backOffPolicyTimeSeed;
    }

    @Override
    public void onStateElection(Task task, TaskState newState) {
        if (this.isNotFailed(newState) || this.isProblematicExceptionAndMustNotRetry(newState) || this.maxAmountOfRetriesReached(task)) {
            return;
        }
        task.scheduleAt(Instant.now().plusSeconds(this.getSecondsToAdd(task)), String.format("Retry %d of %d", this.getFailureCount(task), this.getMaxNumberOfRetries(task)));
    }

    protected long getSecondsToAdd(Task task) {
        return this.getExponentialBackoffPolicy(task, this.backOffPolicyTimeSeed);
    }

    protected long getExponentialBackoffPolicy(Task task, int seed) {
        return (long)Math.pow(seed, this.getFailureCount(task));
    }

    private boolean maxAmountOfRetriesReached(Task task) {
        return this.getFailureCount(task) > (long)this.getMaxNumberOfRetries(task);
    }

    private long getFailureCount(Task task) {
        return task.getTaskStates().stream().filter(StateName.FAILED_STATES).count();
    }

    private boolean isProblematicExceptionAndMustNotRetry(TaskState newState) {
        if (newState instanceof FailedState) {
            return ((FailedState)newState).mustNotRetry();
        }
        return false;
    }

    private boolean isNotFailed(TaskState newState) {
        return !(newState instanceof FailedState);
    }

    private int getMaxNumberOfRetries(Task task) {
        return TaskUtils.getTaskAnnotation(task.getTaskDetails()).map(taskAnnotation -> taskAnnotation.retries() > -1 ? Integer.valueOf(taskAnnotation.retries()) : null).orElse(this.numberOfRetries);
    }
}

