/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.filters;

import cn.boboweike.carrot.tasks.Task;
import cn.boboweike.carrot.tasks.filters.AbstractTaskFilters;
import cn.boboweike.carrot.tasks.filters.ApplyStateFilter;
import cn.boboweike.carrot.tasks.filters.ElectStateFilter;
import cn.boboweike.carrot.tasks.filters.TaskDefaultFilters;
import cn.boboweike.carrot.tasks.filters.TaskFilter;
import cn.boboweike.carrot.tasks.filters.TaskServerFilter;
import cn.boboweike.carrot.tasks.states.TaskState;
import cn.boboweike.carrot.utils.streams.StreamUtils;
import java.util.List;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskPerformingFilters
extends AbstractTaskFilters {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskPerformingFilters.class);
    private Task task;

    public TaskPerformingFilters(Task task, TaskDefaultFilters taskFilters) {
        super(task, taskFilters);
        this.task = task;
    }

    public void runOnStateElectionFilter() {
        this.electStateFilters().forEach(this.catchThrowable(electStateFilter -> electStateFilter.onStateElection(this.task, (TaskState)this.task.getTaskState())));
    }

    public void runOnStateAppliedFilters() {
        this.applyStateFilters().forEach(this.catchThrowable(applyStateFilter -> applyStateFilter.onStateApplied(this.task, this.task.getTaskState(-2), this.task.getTaskState(-1))));
    }

    public void runOnTaskProcessingFilters() {
        this.taskServerFilters().forEach(this.catchThrowable(taskServerFilter -> taskServerFilter.onProcessing(this.task)));
    }

    public void runOnTaskProcessedFilters() {
        this.taskServerFilters().forEach(this.catchThrowable(taskServerFilter -> taskServerFilter.onProcessed(this.task)));
    }

    private Stream<ElectStateFilter> electStateFilters() {
        return TaskPerformingFilters.electStateFilters(this.taskFilters);
    }

    private Stream<ApplyStateFilter> applyStateFilters() {
        return TaskPerformingFilters.applyStateFilters(this.taskFilters);
    }

    private Stream<TaskServerFilter> taskServerFilters() {
        return TaskPerformingFilters.taskServerFilters(this.taskFilters);
    }

    private static Stream<ElectStateFilter> electStateFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, ElectStateFilter.class);
    }

    private static Stream<ApplyStateFilter> applyStateFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, ApplyStateFilter.class);
    }

    private static Stream<TaskServerFilter> taskServerFilters(List<TaskFilter> taskFilters) {
        return StreamUtils.ofType(taskFilters, TaskServerFilter.class);
    }

    @Override
    Logger getLogger() {
        return LOGGER;
    }
}

