/*
 * Decompiled with CFR 0.152.
 */
package cn.boboweike.carrot.tasks.mappers;

import cn.boboweike.carrot.tasks.Task;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.MDC;

public class MDCMapper {
    public static final String CARROT_MDC_KEY = "mdc";

    public static void saveMDCContextToTask(Task task) {
        Map mdcContext = MDC.getCopyOfContextMap();
        if (mdcContext == null) {
            return;
        }
        mdcContext.forEach((key, value) -> task.getMetadata().put("mdc-" + key, value));
    }

    public static void loadMDCContextFromTask(Task task) {
        Map<String, Object> taskMetadata = task.getMetadata();
        Map<String, String> mdcContextMap = taskMetadata.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("mdc-")).collect(Collectors.toMap(entry -> ((String)entry.getKey()).substring(4), entry -> entry.getValue().toString()));
        MDC.setContextMap(mdcContextMap);
    }
}

